<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="overflow-hidden" id="main" role="main">

		<section class="mvc-hero pt-7 lg:pt-9 pb-3.5 lg:pb-7">

			<div class="container px-1.5 lg:px-0 grid grid-cols-12 text-center">
				<div class="col-span-12 lg:col-start-3 2xl:col-start-4 lg:col-end-11 2xl:col-end-10">
					<h1 class="mb-5 lg:mb-7 text-2xl lg:text-3xl font-display"><?php esc_html_e( 'Page Not Found', 'moovcar' ); ?>
					</h1>
					<p class="mb-3">
						<?php esc_html_e( 'This page could not be found. It might have been removed or renamed, or it may never have existed.', 'moovcar' ); ?>
					</p>
					<a class="btn-primary"
						href="<?php echo esc_url( get_home_url() ); ?>"><?php esc_html_e( 'Retour à l\'accueil', 'moovcar' ); ?></a>
				</div>
			</div>

		</section>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();