<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="pb-7 lg:pb-10 overflow-hidden" id="main" role="main">

		<section class="mvc-hero pt-7 lg:pt-9 pb-3.5 lg:pb-7">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12 text-center">
				<div class="col-span-12 lg:col-start-3 2xl:col-start-4 lg:col-end-11 2xl:col-end-10">
					<h1 class="mb-5 lg:mb-7 text-2xl lg:text-3xl font-display">
						<?php echo wp_kses( sprintf( /* translators: category name */ __( 'Nos conseils dans la catégorie : <span class="lowercase">%s</span>', 'moovcar' ), get_queried_object()->name ), mvc_allowed_html() ); ?>
					</h1>
				</div>

				<div class="col-span-12">
					<?php get_template_part( 'template-parts/content/categories', 'menu' ); ?>
				</div>
			</div>
		</section>

		<?php if ( have_posts() ) : ?>

		<section class="mvc-posts container px-1.5 lg:px-0">
			<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-1">

				<?php
				// Load posts loop.
				while ( have_posts() ) {
					the_post();
					get_template_part( 'template-parts/content/content', 'loop' );
				}
				?>

			</div>

			<?php
			// Previous/next page navigation.
			mvc_the_posts_navigation();

			else :

				// If no content, include the "No posts found" template.
				get_template_part( 'template-parts/content/content', 'none' );
				?>

		</section>

		<?php endif; ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();
