<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no `home.php` file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="overflow-hidden" id="main" role="main">

		<div
			class="fp-hero relative h-42 lg:h-[72rem] pt-10 flex flex-col items-center text-center z-0 after:absolute after:top-full after:left-0 after:w-full after:h-4 after:bg-green-100 after:-z-10">
			<div
				class="absolute inset-0 bg-gradient-to-b from-green-50 from-[4.52%] via-[#9CCBC050] via-[47%] to-green-100 to-100% -z-50">
				<img class="absolute top-4 left-1/2 -translate-x-1/2" width="1274" height="418"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/hero-ellipses.svg" alt="" aria-hidden="true">
			</div>
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 lg:col-start-2 2xl:col-start-3 lg:col-end-12 2xl:col-end-11">
					<h1 class="mb-3 text-2xl lg:text-3xl font-display">
						<?php esc_html_e( 'Offrez une vision à 360° de vos véhicules avec un plateau tournant', 'moovcar' ); ?></h1>
					<p class="mx-auto mb-2 max-w-full w-[660px]">
						<?php echo wp_kses( __( 'Moovcar360 propose des plateaux tournants robotisés pour la présentation de véhicules, optimisés pour les photos et vidéos à 360°. Destinés aux concessionnaires et garages, <span class="whitespace-nowrap">nos solutions</span> garantissent une mise en valeur parfaite de vos voitures avec <span class="whitespace-nowrap">une installation sur-mesure.</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
					<a href="<?php echo esc_url( get_permalink( 11 ) ); ?>"
						class="btn-primary"><?php esc_html_e( 'Découvrez nos plateaux tournants', 'moovcar' ); ?></a>
				</div>
			</div>

			<div class="anim-container mt-auto">
				<div class="turn-table w-[714px] lg:w-[1070px] h-[359px] lg:h-[538px] translate-y-2 lg:translate-y-0">
					<img class="h-full" width="1070" height="538"
						src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-0.webp"
						alt="">
				</div>

				<div class="turn-table-images pt-[10vh] md:mt-0 absolute inset-0 flex flex-col pointer-events-none">
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-0.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-1.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-2.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-3.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-4.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-5.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-6.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-7.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-8.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-9.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-10.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-11.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-12.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-13.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-14.webp"
							alt="">
					</div>
					<div class="md:flex-1 h-[15vh] md:h-auto">
						<img width="1070" height="538" class="w-0 h-0 invisible"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-15.webp"
							alt="">
					</div>
				</div>
			</div>
		</div>

		<section class="mvc-intro relative pt-3 pb-5.5 lg:pb-11 bg-background rounded-t-btn">
			<div class="container px-1.5 lg:px-0">
				<div class="mb-3.5 lg:mb-7 text-center">
					<div
						class="px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-foreground rounded-btn text-sm font-display uppercase">
						<svg xmlns="http://www.w3.org/2000/svg" width="19" height="17" viewBox="0 0 19 17" fill="none"
							aria-hidden="true">
							<path
								d="M8.85714 6.83561V12.6598C8.85714 12.8296 8.92487 12.9924 9.04543 13.1124C9.16599 13.2324 9.3295 13.2999 9.5 13.2999C9.6705 13.2999 9.83401 13.2324 9.95457 13.1124C10.0751 12.9924 10.1429 12.8296 10.1429 12.6598V6.83561C10.9233 6.677 11.6168 6.23553 12.0889 5.59678C12.561 4.95803 12.7781 4.16751 12.698 3.37849C12.6179 2.58946 12.2465 1.85814 11.6556 1.3263C11.0647 0.794463 10.2965 0.5 9.5 0.5C8.70345 0.5 7.93528 0.794463 7.3444 1.3263C6.75353 1.85814 6.38205 2.58946 6.30199 3.37849C6.22193 4.16751 6.43899 4.95803 6.91109 5.59678C7.38318 6.23553 8.07669 6.677 8.85714 6.83561ZM9.5 1.7794C9.88144 1.7794 10.2543 1.89201 10.5715 2.10299C10.8886 2.31397 11.1358 2.61385 11.2818 2.9647C11.4277 3.31554 11.4659 3.70161 11.3915 4.07407C11.3171 4.44653 11.1334 4.78865 10.8637 5.05718C10.594 5.32571 10.2504 5.50858 9.87625 5.58266C9.50214 5.65675 9.11437 5.61873 8.76197 5.4734C8.40957 5.32807 8.10837 5.08197 7.89645 4.76622C7.68454 4.45046 7.57143 4.07923 7.57143 3.69948C7.57143 3.19024 7.77462 2.70186 8.13629 2.34178C8.49797 1.98169 8.98851 1.7794 9.5 1.7794ZM18.5 12.6598C18.5 15.1543 13.8626 16.5 9.5 16.5C5.13741 16.5 0.5 15.1543 0.5 12.6598C0.5 12.0406 0.806161 11.1294 2.26786 10.3069C3.25304 9.75172 4.60786 9.32531 6.18687 9.0733C6.2704 9.06016 6.3557 9.06354 6.43792 9.08323C6.52013 9.10292 6.59765 9.13854 6.66603 9.18805C6.73442 9.23757 6.79234 9.30001 6.83649 9.37181C6.88064 9.44361 6.91016 9.52336 6.92335 9.60652C6.93654 9.68968 6.93315 9.7746 6.91337 9.85646C6.8936 9.93831 6.85782 10.0155 6.80809 10.0836C6.75835 10.1517 6.69564 10.2093 6.62352 10.2533C6.5514 10.2972 6.47129 10.3266 6.38777 10.3397C4.9783 10.5654 3.73598 10.9502 2.89866 11.4238C2.19152 11.8198 1.78571 12.271 1.78571 12.6598C1.78571 13.7287 4.72036 15.2199 9.5 15.2199C14.2796 15.2199 17.2143 13.7287 17.2143 12.6598C17.2143 12.271 16.8085 11.8198 16.1013 11.4206C15.2608 10.947 14.0217 10.5622 12.6122 10.3365C12.5269 10.3255 12.4447 10.2974 12.3705 10.2541C12.2963 10.2108 12.2316 10.1532 12.1801 10.0845C12.1287 10.0158 12.0917 9.9376 12.0712 9.85443C12.0507 9.77125 12.0471 9.68482 12.0608 9.60027C12.0745 9.51571 12.105 9.43474 12.1507 9.36216C12.1964 9.28958 12.2562 9.22686 12.3266 9.17772C12.3971 9.12858 12.4767 9.09402 12.5609 9.07608C12.645 9.05815 12.7318 9.0572 12.8163 9.0733C14.3954 9.32531 15.7502 9.75172 16.7354 10.3069C18.1938 11.1294 18.5 12.0406 18.5 12.6598Z"
								fill="#2D4140" />
						</svg>
						<span><?php esc_html_e( 'Une vision 360°', 'moovcar' ); ?></span>
					</div>
				</div>

				<div class="grid grid-cols-12 gap-1">
					<div class="col-span-12 lg:col-span-5">
						<h2 class="mb-4 text-2xl font-display">
							<?php esc_html_e( 'Qu\'est-ce qu\'un plateau tournant et comment fonctionne-t-il ?', 'moovcar' ); ?>
						</h2>
						<button type="button" data-micromodal-trigger="contact" class="btn-primary !hidden lg:!inline-flex"
							aria-label="<?php esc_html_e( 'Ouvrir la modale de prise de contact', 'moovcar' ); ?>"><?php esc_html_e( 'Contactez-nous', 'moovcar' ); ?></button>
					</div>
					<div class="col-span-12 lg:col-start-7 lg:col-end-13 lg:pt-4">

						<p class="mb-1.5 font-medium">
							<?php esc_html_e( 'Un plateau tournant motorisé est une plateforme rotative conçue pour faire pivoter des véhicules, principalement des voitures, afin d’en faciliter la présentation sous tous les angles.', 'moovcar' ); ?>
						</p>

						<p class="mb-1.5">
							<?php esc_html_e( 'Ces dispositifs sont très utilisés dans les concessionnaires automobiles et les garages pour des photos et vidéos à 360°, ou encore pour optimiser l\'espace dans des garages.', 'moovcar' ); ?>
						</p>

						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Grâce à sa rotation fluide et réglable, il vous permet <span class="font-medium">d’exposer chaque détail de vos voitures</span>, captivant ainsi vos clients. Nos plateaux sont adaptés aux différents besoins : versions surélevées pour une installation rapide ou encastrées pour une intégration parfaite dans votre espace. Robuste et facile à utiliser, ce plateau est conçu pour durer et demande un entretien minimal. Optez pour une présentation qui valorise vos véhicules et attire plus d\'acheteurs !', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>

						<button type="button" data-micromodal-trigger="contact" class="btn-primary mt-2 lg:!hidden"
							aria-label="<?php esc_html_e( 'Ouvrir la modale de prise de contact', 'moovcar' ); ?>"><?php esc_html_e( 'Contactez-nous', 'moovcar' ); ?></button>

					</div>
				</div>
			</div>
		</section>

		<section class="mvc-advantages relative pt-6 lg:pt-9 px-1.5 lg:px-0 text-background bg-foreground overflow-hidden">
			<div class="relative mb-7 text-center z-10">
				<div
					class="mb-2 px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-background rounded-btn text-sm font-display uppercase">
					<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none"
						aria-hidden="true">
						<path
							d="M17.0294 11.5511L12.7983 9.98755L11.2397 5.7531C11.1474 5.50235 10.9804 5.28595 10.7612 5.13309C10.5421 4.98023 10.2813 4.89828 10.0141 4.89828C9.74692 4.89828 9.48616 4.98023 9.26701 5.13309C9.04786 5.28595 8.88087 5.50235 8.78857 5.7531L7.22013 9.98755L2.98568 11.5461C2.73493 11.6384 2.51853 11.8054 2.36567 12.0246C2.21282 12.2437 2.13086 12.5045 2.13086 12.7717C2.13086 13.0389 2.21282 13.2996 2.36567 13.5188C2.51853 13.7379 2.73493 13.9049 2.98568 13.9972L7.22013 15.5657L8.77873 19.8001C8.87102 20.0509 9.03801 20.2673 9.25716 20.4201C9.47632 20.573 9.73708 20.6549 10.0043 20.6549C10.2715 20.6549 10.5322 20.573 10.7514 20.4201C10.9705 20.2673 11.1375 20.0509 11.2298 19.8001L12.7983 15.5657L17.0327 14.0071C17.2835 13.9148 17.4999 13.7478 17.6527 13.5286C17.8056 13.3095 17.8875 13.0487 17.8875 12.7815C17.8875 12.5143 17.8056 12.2536 17.6527 12.0344C17.4999 11.8153 17.2835 11.6483 17.0327 11.556L17.0294 11.5511ZM12.06 14.4353C11.9709 14.4681 11.89 14.5199 11.8229 14.587C11.7557 14.6541 11.704 14.735 11.6711 14.8241L10.0092 19.3268L8.35052 14.8274C8.31775 14.7374 8.26566 14.6556 8.19792 14.5879C8.13018 14.5201 8.04843 14.4681 7.95841 14.4353L3.459 12.7766L7.95841 11.1179C8.04843 11.0852 8.13018 11.0331 8.19792 10.9653C8.26566 10.8976 8.31775 10.8158 8.35052 10.7258L10.0092 6.22642L11.6679 10.7258C11.7007 10.8149 11.7525 10.8958 11.8196 10.9629C11.8867 11.0301 11.9676 11.0818 12.0567 11.1147L16.5594 12.7766L12.06 14.4353ZM12.6342 4.24536C12.6342 4.07131 12.7033 3.90439 12.8264 3.78132C12.9495 3.65825 13.1164 3.58911 13.2904 3.58911H14.6029V2.27661C14.6029 2.10256 14.6721 1.93564 14.7952 1.81257C14.9182 1.6895 15.0851 1.62036 15.2592 1.62036C15.4332 1.62036 15.6002 1.6895 15.7232 1.81257C15.8463 1.93564 15.9154 2.10256 15.9154 2.27661V3.58911H17.2279C17.402 3.58911 17.5689 3.65825 17.692 3.78132C17.8151 3.90439 17.8842 4.07131 17.8842 4.24536C17.8842 4.41941 17.8151 4.58633 17.692 4.7094C17.5689 4.83247 17.402 4.90161 17.2279 4.90161H15.9154V6.21411C15.9154 6.38816 15.8463 6.55508 15.7232 6.67815C15.6002 6.80122 15.4332 6.87036 15.2592 6.87036C15.0851 6.87036 14.9182 6.80122 14.7952 6.67815C14.6721 6.55508 14.6029 6.38816 14.6029 6.21411V4.90161H13.2904C13.1164 4.90161 12.9495 4.83247 12.8264 4.7094C12.7033 4.58633 12.6342 4.41941 12.6342 4.24536ZM21.1654 8.18286C21.1654 8.35691 21.0963 8.52383 20.9732 8.6469C20.8502 8.76997 20.6832 8.83911 20.5092 8.83911H19.8529V9.49536C19.8529 9.66941 19.7838 9.83633 19.6607 9.9594C19.5377 10.0825 19.3707 10.1516 19.1967 10.1516C19.0226 10.1516 18.8557 10.0825 18.7327 9.9594C18.6096 9.83633 18.5404 9.66941 18.5404 9.49536V8.83911H17.8842C17.7101 8.83911 17.5432 8.76997 17.4202 8.6469C17.2971 8.52383 17.2279 8.35691 17.2279 8.18286C17.2279 8.00881 17.2971 7.84189 17.4202 7.71882C17.5432 7.59575 17.7101 7.52661 17.8842 7.52661H18.5404V6.87036C18.5404 6.69631 18.6096 6.52939 18.7327 6.40632C18.8557 6.28325 19.0226 6.21411 19.1967 6.21411C19.3707 6.21411 19.5377 6.28325 19.6607 6.40632C19.7838 6.52939 19.8529 6.69631 19.8529 6.87036V7.52661H20.5092C20.6832 7.52661 20.8502 7.59575 20.9732 7.71882C21.0963 7.84189 21.1654 8.00881 21.1654 8.18286Z"
							fill="white" />
					</svg>
					<span><?php esc_html_e( 'Nos avantages', 'moovcar' ); ?></span>
				</div>
				<h2 class="text-2xl font-display">
					<?php echo wp_kses( __( '<span class="whitespace-nowrap">Pourquoi choisir</span> <span class="whitespace-nowrap">MOOVCAR 360° ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
				</h2>
			</div>

			<div class="relative pb-7 lg:pb-14 container grid grid-cols-12 gap-x-1 z-0">
				<div class="col-span-12 md:col-start-6 lg:col-start-9 md:col-end-13 mb-6 md:mb-0 flex flex-col gap-y-2.5">
					<div class="py-2 lg:py-2.5 px-2 lg:px-3 flex flex-col gap-y-2 bg-black/20 backdrop-blur-md rounded-md">
						<div class="w-[49px] h-[49px] bg-green-75 rounded-full flex items-center justify-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="27" viewBox="0 0 25 27" fill="none"
								aria-hidden="true">
								<path d="M12.5 13.6293V25.9534" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M1.08398 7.37976L12.5001 13.6281L23.9163 7.37976" stroke="#2D4140" stroke-width="1.5"
									stroke-linecap="round" stroke-linejoin="round" />
								<path
									d="M23.5017 20.0681L12.96 25.8397C12.819 25.9169 12.6608 25.9573 12.5 25.9573C12.3392 25.9573 12.181 25.9169 12.04 25.8397L1.49833 20.0681C1.34781 19.9858 1.22216 19.8645 1.1345 19.717C1.04684 19.5695 1.00039 19.4012 1 19.2296V7.77032C1.00039 7.59874 1.04684 7.43041 1.1345 7.28291C1.22216 7.1354 1.34781 7.01414 1.49833 6.93178L12.04 1.16022C12.181 1.08305 12.3392 1.0426 12.5 1.0426C12.6608 1.0426 12.819 1.08305 12.96 1.16022L23.5017 6.93178C23.6522 7.01414 23.7778 7.1354 23.8655 7.28291C23.9532 7.43041 23.9996 7.59874 24 7.77032V19.2272C24 19.3992 23.9538 19.568 23.8661 19.716C23.7784 19.8639 23.6525 19.9856 23.5017 20.0681Z"
									stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M6.9375 3.95251L18.2506 10.1445V16.3737" stroke="#2D4140" stroke-width="1.5"
									stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						</div>
						<h3 class="text-lg font-display"><?php esc_html_e( 'Livraison en France et en Belgique', 'moovcar' ); ?>
						</h3>
						<p>
							<?php esc_html_e( 'Simplifiez vos projets grâce à notre service de livraison en France et en Belgique. Nous vous livrons directement, où que vous soyez. Un gain de temps et d\'énergie pour vous permettre de vous concentrer sur l\'essentiel : vos véhicules. Vous recevez votre plateau tournant prêt à l\'emploi, sans la moindre complication.', 'moovcar' ); ?>
						</p>
					</div>
					<div class="py-2 lg:py-2.5 px-2 lg:px-3 flex flex-col gap-y-2 bg-black/20 backdrop-blur-md rounded-md">
						<div class="w-[49px] h-[49px] bg-green-75 rounded-full flex items-center justify-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="27" height="20" viewBox="0 0 27 20" fill="none"
								aria-hidden="true">
								<path d="M13.5 0.25V14.25M13.5 14.25L8 8.88333M13.5 14.25L19 8.88333" stroke="#2D4140"
									stroke-width="1.5" stroke-linejoin="bevel" />
								<path
									d="M5.02 12.4166C2.86818 13.0893 1.53711 14.0138 1.53711 15.0366C1.53711 17.0883 6.89319 18.75 13.5001 18.75C20.107 18.75 25.463 17.0868 25.463 15.0366C25.463 14.0138 24.132 13.0893 21.9801 12.4182"
									stroke="#2D4140" stroke-width="1.5" stroke-miterlimit="10" />
							</svg>
						</div>
						<h3 class="text-lg font-display"><?php esc_html_e( 'Installation sur-mesure', 'moovcar' ); ?>
						</h3>
						<p>
							<?php esc_html_e( 'Chez MOOVCAR360, nous garantissons une installation facile et rapide, adaptée à vos besoins spécifiques. Nos équipes d\'experts s\'occupent de tout, pour que votre plateau tournant soit opérationnel en un temps record. De plus, toutes nos installations sont couvertes par une garantie pièces et main-d\'œuvre, vous assurant une tranquillité d\'esprit totale.', 'moovcar' ); ?>
						</p>
					</div>
					<div class="py-2 lg:py-2.5 px-2 lg:px-3 flex flex-col gap-y-2 bg-black/20 backdrop-blur-md rounded-md">
						<div class="w-[49px] h-[49px] bg-green-75 rounded-full flex items-center justify-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
								aria-hidden="true">
								<path
									d="M12.1413 2.37197L13.8131 5.74323C14.041 6.21253 14.649 6.66267 15.1619 6.74886L18.1921 7.25647C20.1299 7.5821 20.5858 8.99956 19.1895 10.3979L16.8337 12.7731C16.4348 13.1753 16.2163 13.9511 16.3398 14.5066L17.0142 17.4469C17.5462 19.7742 16.3208 20.6745 14.2785 19.4581L11.4383 17.7629C10.9254 17.4564 10.08 17.4564 9.55754 17.7629L6.71735 19.4581C4.68458 20.6745 3.44972 19.7646 3.98166 17.4469L4.65608 14.5066C4.77957 13.9511 4.56109 13.1753 4.16214 12.7731L1.8064 10.3979C0.41955 8.99956 0.866001 7.5821 2.80379 7.25647L5.83395 6.74886C6.3374 6.66267 6.94533 6.21253 7.1733 5.74323L8.84512 2.37197C9.75702 0.542677 11.2389 0.542677 12.1413 2.37197Z"
									fill="#11DAAB" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						</div>
						<h3 class="text-lg font-display"><?php esc_html_e( 'Des produits de qualité', 'moovcar' ); ?>
						</h3>
						<p>
							<?php esc_html_e( 'Chez MOOVCAR360, nous ne faisons aucun compromis sur la qualité. Nos plateaux tournants sont conçus avec des matériaux robustes et durables pour garantir une performance irréprochable à chaque rotation. Nos produits sont spécifiquement développés pour répondre aux exigences des professionnels de l\'automobile. En choisissant MOOVCAR360, vous optez pour l\'excellence et l\'expertise d’un spécialiste du plateau tournant.', 'moovcar' ); ?>
						</p>
					</div>
				</div>

				<div class="anim-container relative col-span-12 md:absolute md:inset-0">
					<div
						class="turn-table absolute top-0 left-1/2 -translate-x-1/2 md:translate-x-0 md:-left-1/3 lg:-left-6 w-[714px] lg:w-[1070px] h-[359px] lg:h-[538px] -z-10">
						<div
							class="absolute top-1/2 lg:top-0 left-1/2 lg:left-1/4 -translate-x-1/2 lg:translate-x-0 -translate-y-1/2 lg:-translate-y-1/3 w-[1106px] h-[818px] rounded-[1106px] bg-green-100/50 blur-[165px] -z-50">
						</div>
						<img class="h-full" width="1070" height="538"
							src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-0.webp"
							alt="">
					</div>

					<div class="turn-table-images md:absolute md:inset-0 md:pb-7 lg:pb-14 flex flex-col pointer-events-none">
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-0.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-1.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-2.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-3.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-4.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-5.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-6.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-7.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-8.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-9.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-10.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-11.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-12.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-13.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-14.webp"
								alt="">
						</div>
						<div class="md:flex-1 h-[15vh] md:h-auto">
							<img width="1070" height="538" class="w-0 h-0 invisible"
								src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/animation/moovcar360-voiture-image-15.webp"
								alt="">
						</div>
					</div>
				</div>
			</div>

		</section>

		<section class="mvc-uses py-7 lg:py-10 container px-1.5 md:px-0">

			<h2 class="mb-3 text-2xl lg:text-3xl font-display max-w-full w-[640px]">
				<?php esc_html_e( 'Les différentes utilisations du plateau tournant', 'moovcar' ); ?>
			</h2>

			<?php get_template_part( 'template-parts/block', 'services' ); ?>
		</section>

		<?php get_template_part( 'template-parts/block', 'partners' ); ?>

		<?php get_template_part( 'template-parts/realisation/content', 'list' ); ?>

		<?php get_template_part( 'template-parts/reviews/content', 'list' ); ?>

		<section class="mvc-faq mt-7 lg:mt-10 py-7 lg:py-10 bg-green-150 text-white">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 lg:col-start-3 lg:col-end-11">
					<h2 class="mb-4 text-2xl font-display text-center">
						<?php esc_html_e( 'Foire aux questions', 'moovcar' ); ?>
					</h2>
					<?php
					$faq_blocks = mvc_find_blocks( parse_blocks( get_the_content() ), 'yoast/faq-block' );

					foreach ( $faq_blocks as $faq_block ) {
						echo $faq_block['innerHTML'];
					}
					?>
				</div>
			</div>
		</section>

		<?php get_template_part( 'template-parts/block', 'contact-form' ); ?>

		<?php get_template_part( 'template-parts/content/content', 'list' ); ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();
