<?php
/**
 * Template name: Usage / Encastré
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="pb-7 lg:pb-10" id="main" role="main">

		<section class="pt-4.5 pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12 gap-y-5">

				<div class="col-span-12 lg:col-span-6">
					<div class="swiper product-images mb-1" data-slides-per-view="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage-2.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage-3.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
									alt="">

							</div>
						</div>
					</div>

					<div class="product-thumbs relative px-2">
						<div class="swiper" data-slides-per-view="1">
							<div class="swiper-wrapper">
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage-2.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre-gerard-garage-3.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/encastre/moovcar360-garage-plateau-tournant-encastre.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
										alt="">

								</div>
							</div>
						</div>
					</div>
					<div class="swiper-navigation">
						<div class="swiper-btn-prev">
							<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
								<path
									d="M7,14c-.26,0-.51-.1-.71-.29L.29,7.71c-.39-.39-.39-1.02,0-1.41L6.29.29c.39-.39,1.02-.39,1.41,0s.39,1.02,0,1.41L2.41,7l5.29,5.29c.39.39.39,1.02,0,1.41-.2.2-.45.29-.71.29Z" />
							</svg>
						</div>
						<div class="swiper-btn-next">
							<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
								<path
									d="M1,14c-.26,0-.51-.1-.71-.29-.39-.39-.39-1.02,0-1.41l5.29-5.29L.29,1.71C-.1,1.32-.1.68.29.29S1.32-.1,1.71.29l6,6c.39.39.39,1.02,0,1.41L1.71,13.71c-.2.2-.45.29-.71.29Z" />
							</svg>
						</div>
					</div>
				</div>

				<div class="col-span-12 lg:col-start-8 lg:col-end-13">
					<h1 class="mb-2 text-2xl font-display max-w-full w-[308px]">
						<?php esc_html_e( 'Optez pour un plateau tournant encastré', 'moovcar' ); ?></h1>
					<p class="mx-auto mb-5">
						<?php esc_html_e( 'Imaginez l’impact d’une présentation automobile qui offre une vue complète et fluide à 360°, sublimant vos véhicules sous tous les angles. Avec le plateau tournant encastré Moovcar360, transformez chaque démonstration en une expérience visuelle captivante et augmentez votre potentiel de vente.', 'moovcar' ); ?>
					</p>
					<div class="product-price mb-2 flex justify-between items-center gap-2">
						<span class="text-xl font-display">13 900€ <?php esc_html_e( 'HT', 'moovcar' ); ?></span>
						<button type="button" data-micromodal-trigger="devis"
							class="btn-primary"><?php esc_html_e( 'Obtenir un devis', 'moovcar' ); ?></button>
					</div>
					<div class="product-details accordion-container">
						<div class="ac features">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"
										aria-hidden="true">
										<path d="M9.79297 7.02991H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 7.02991L5.64453 7.62366L7.42578 5.84241" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M9.79297 12.5716H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 12.5716L5.64453 13.1653L7.42578 11.3841" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path
											d="M7.12565 17.4167H11.8757C15.834 17.4167 17.4173 15.8333 17.4173 11.875V7.12499C17.4173 3.16666 15.834 1.58333 11.8757 1.58333H7.12565C3.16732 1.58333 1.58398 3.16666 1.58398 7.12499V11.875C1.58398 15.8333 3.16732 17.4167 7.12565 17.4167Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Caractéristiques', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Le plateau tournant encastré Moovcar360 est conçu pour répondre aux besoins exigeants des professionnels de l’automobile. Conçu avec précision et robustesse, il supporte des charges importantes tout en offrant une rotation stable et fluide. Voici ses caractéristiques qui en font un atout essentiel pour vos présentations :', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre de la plateforme</span> : 430 cm, idéal pour exposer tous types de véhicules, même les plus imposants.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 470 cm, garantissant une rotation à 360° pour une vue complète et immersive.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur</span> : Seulement 9 cm, une intégration discrète qui s’adapte facilement à votre environnement, qu’il s’agisse d’un garage ou d’un atelier.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Surface d’installation</span> : Nécessite 36 m² et un sol plat pour assurer une stabilité irréprochable durant chaque rotation.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Alimentation</span> : Compatible avec une prise standard de 220 V, simplifiant son installation dans divers lieux d’exposition.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Construction durable</span> : Fabriqué à partir de 11 panneaux en tôle de 2 mm d’épaisseur, ce plateau est conçu pour résister aux usages intensifs tout en assurant une stabilité maximale.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Rampes en acier renforcé</span> : Avec une épaisseur de 3 mm, elles supportent sans problème le poids des véhicules les plus lourds.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Mécanisme de rotation fluide</span> : Les 5 chariots par panneau assurent un mouvement régulier sans secousses, offrant une fluidité essentielle pour les prises de vue.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Système motorisé performant</span> : 4 moteurs intégrés et un système électrique sécurisé permettent une rotation précise et sans à-coups.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Panneau de commande</span> : Réglez facilement la vitesse de rotation pour une présentation parfaitement adaptée à votre style et vos besoins.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Télécommandes incluses</span> : Deux télécommandes facilitent le contrôle à distance, offrant une flexibilité et un confort d’utilisation optimaux.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac dimensions">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path
											d="M17.7188 3.9375V7.875C17.7188 8.04905 17.6496 8.21597 17.5265 8.33904C17.4035 8.46211 17.2365 8.53125 17.0625 8.53125C16.8885 8.53125 16.7215 8.46211 16.5985 8.33904C16.4754 8.21597 16.4062 8.04905 16.4062 7.875V5.52152L12.2768 9.6518C12.1537 9.77494 11.9866 9.84411 11.8125 9.84411C11.6384 9.84411 11.4713 9.77494 11.3482 9.6518C11.2251 9.52866 11.1559 9.36165 11.1559 9.1875C11.1559 9.01335 11.2251 8.84634 11.3482 8.7232L15.4785 4.59375H13.125C12.951 4.59375 12.784 4.52461 12.661 4.40154C12.5379 4.27847 12.4688 4.11155 12.4688 3.9375C12.4688 3.76345 12.5379 3.59653 12.661 3.47346C12.784 3.35039 12.951 3.28125 13.125 3.28125H17.0625C17.2365 3.28125 17.4035 3.35039 17.5265 3.47346C17.6496 3.59653 17.7188 3.76345 17.7188 3.9375ZM8.7232 11.3482L4.59375 15.4785V13.125C4.59375 12.951 4.52461 12.784 4.40154 12.661C4.27847 12.5379 4.11155 12.4688 3.9375 12.4688C3.76345 12.4688 3.59653 12.5379 3.47346 12.661C3.35039 12.784 3.28125 12.951 3.28125 13.125V17.0625C3.28125 17.2365 3.35039 17.4035 3.47346 17.5265C3.59653 17.6496 3.76345 17.7188 3.9375 17.7188H7.875C8.04905 17.7188 8.21597 17.6496 8.33904 17.5265C8.46211 17.4035 8.53125 17.2365 8.53125 17.0625C8.53125 16.8885 8.46211 16.7215 8.33904 16.5985C8.21597 16.4754 8.04905 16.4062 7.875 16.4062H5.52152L9.6518 12.2768C9.77494 12.1537 9.84411 11.9866 9.84411 11.8125C9.84411 11.6384 9.77494 11.4713 9.6518 11.3482C9.52866 11.2251 9.36165 11.1559 9.1875 11.1559C9.01335 11.1559 8.84634 11.2251 8.7232 11.3482Z"
											fill="#2D4140" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Dimensions', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Le plateau tournant encastré Moovcar360 est conçu pour s’intégrer harmonieusement dans divers espaces professionnels, tels que des garages, ateliers, ou showrooms.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre de la plateforme</span> : 430 cm, parfait pour exposer tout type de véhicule, des classiques aux modèles plus imposants.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 500 cm, permettant une rotation complète et en toute sécurité.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur réduite</span> : Avec seulement 9 cm, ce plateau s\'intègre avec discrétion dans votre espace sans en compromettre l’esthétique.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Surface nécessaire</span> : Une surface de 36 m² est requise, ainsi qu’une alimentation standard de 220 V pour une installation simplifiée et rapide.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac livraison">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path d="M2.77344 6.50995L10.4997 10.9812L18.1734 6.53617" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M10.5 18.909V10.9727" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path
											d="M8.68928 2.17L4.01678 4.76878C2.95803 5.35503 2.0918 6.82501 2.0918 8.03251V12.9763C2.0918 14.1838 2.95803 15.6538 4.01678 16.24L8.68928 18.8388C9.68678 19.39 11.323 19.39 12.3205 18.8388L16.993 16.24C18.0518 15.6538 18.918 14.1838 18.918 12.9763V8.03251C18.918 6.82501 18.0518 5.35503 16.993 4.76878L12.3205 2.17C11.3143 1.61 9.68678 1.61 8.68928 2.17Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
										<path d="M14.8741 11.5851V8.38262L6.57031 3.58759" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Livraison et installation', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Profitez d’une livraison et d’une installation sur mesure pour votre plateau tournant Moovcar360.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Si le modèle est en stock, il est livré sous 10 à 15 jours. Pour des commandes spécifiques, le délai peut s’étendre à 8 semaines. Une fois le plateau arrivé, notre équipe se charge de l’installer pour garantir un fonctionnement fluide dès les premiers instants. Attention, il faut que la surface soit prête à accueillir le plateau encastré.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<p>
										<?php echo wp_kses( __( 'Tarif de livraison et installation : 1 900 € HT, payables à la fin de l’installation pour plus de flexibilité.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		</section>

		<section class="grid grid-cols-1 lg:grid-cols-2 items-center bg-green-150 text-white">
			<div class="py-5.5 px-1.5 md:px-5.5">
				<h2 class="max-w-full w-[530px] mb-2 text-2xl font-display">
					<?php echo wp_kses( __( 'Pourquoi opter pour un plateau tournant <span class="whitespace-nowrap">encastré ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
				</h2>
				<p class="max-w-full w-[530px]">
					<?php echo wp_kses( __( 'Le plateau tournant encastré offre des avantages uniques qui maximisent votre espace et valorisent votre parc automobile :', 'moovcar' ), mvc_allowed_html() ); ?>
				</p>
			</div>
			<picture class="relative h-[400px] lg:h-[677px]">
				<img class="w-full h-full object-cover" width="713" height="677"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-plateau-pourquoi.jpg" alt="">
			</picture>
		</section>

		<section class="bg-green-25">

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-2 -translate-y-11 -mb-11">

				<div class="p-3 bg-white border-b lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
							target="_blank">
							<path
								d="M7.90007 16.0997L2.73539 14.1966C2.59298 14.144 2.4701 14.0491 2.38332 13.9245C2.29653 13.8 2.25 13.6518 2.25 13.5C2.25 13.3482 2.29653 13.2001 2.38332 13.0755C2.4701 12.951 2.59298 12.856 2.73539 12.8034L7.90007 10.9003L9.8032 5.73563C9.85577 5.59322 9.95072 5.47035 10.0753 5.38356C10.1998 5.29677 10.348 5.25024 10.4998 5.25024C10.6516 5.25024 10.7997 5.29677 10.9243 5.38356C11.0488 5.47035 11.1438 5.59322 11.1963 5.73563L13.0994 10.9003L18.2641 12.8034C18.4065 12.856 18.5294 12.951 18.6162 13.0755C18.703 13.2001 18.7495 13.3482 18.7495 13.5C18.7495 13.6518 18.703 13.8 18.6162 13.9245C18.5294 14.0491 18.4065 14.144 18.2641 14.1966L13.0994 16.0997L11.1963 21.2644C11.1438 21.4068 11.0488 21.5297 10.9243 21.6165C10.7997 21.7032 10.6516 21.7498 10.4998 21.7498C10.348 21.7498 10.1998 21.7032 10.0753 21.6165C9.95072 21.5297 9.85577 21.4068 9.8032 21.2644L7.90007 16.0997Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path d="M16.5 1.5V6" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M21 6.75V9.75" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M14.25 3.75H18.75" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M19.5 8.25H22.5" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Esthétique et discrétion', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Il se fond parfaitement dans votre sol pour une installation discrète et élégante.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
							aria-hidden="true">
							<path d="M15.4512 3.375H20.6261V8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M14.5879 9.41247L20.6254 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M8.54998 20.6249H3.375V15.45" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M9.41247 14.5875L3.375 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M20.6261 15.45V20.6249H15.4512" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M14.5879 14.5875L20.6254 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M3.375 8.54998V3.375H8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M9.41247 9.41247L3.375 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Fonctionnalité et gain de place', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Un plateau encastré optimise chaque mètre carré, transformant votre espace en un véritable atout pour les démonstrations.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
							aria-hidden="true">
							<path
								d="M1.5 6.00006C1.4999 5.88513 1.52621 5.77171 1.5769 5.66857C1.6276 5.56543 1.70132 5.47531 1.79237 5.40519C1.88343 5.33506 1.98938 5.2868 2.10205 5.26413C2.21472 5.24146 2.3311 5.24498 2.44219 5.27443C4.06406 5.70849 7.635 6.75006 12 6.75006C16.365 6.75006 19.9359 5.70849 21.5625 5.27537C21.6732 5.24679 21.789 5.24389 21.901 5.26691C22.013 5.28992 22.1182 5.33824 22.2087 5.40817C22.2991 5.47809 22.3724 5.56778 22.4229 5.67036C22.4734 5.77295 22.4998 5.88572 22.5 6.00006V18.0001C22.5 18.115 22.4736 18.2284 22.4228 18.3315C22.372 18.4346 22.2981 18.5247 22.207 18.5947C22.1158 18.6648 22.0098 18.7129 21.8971 18.7355C21.7843 18.758 21.668 18.7543 21.5569 18.7247C19.9341 18.2888 16.3641 17.2501 12 17.2501C7.63594 17.2501 4.06594 18.2888 2.44313 18.7238C2.33213 18.7534 2.21581 18.7571 2.10316 18.7346C1.99051 18.7121 1.88454 18.664 1.7934 18.5941C1.70227 18.5242 1.62842 18.4342 1.57755 18.3312C1.52668 18.2282 1.50015 18.1149 1.5 18.0001V6.00006Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path
								d="M19.5 10.125C19.5 10.3321 19.3321 10.5 19.125 10.5C18.9179 10.5 18.75 10.3321 18.75 10.125C18.75 9.91789 18.9179 9.75 19.125 9.75C19.3321 9.75 19.5 9.91789 19.5 10.125Z"
								stroke="#11DAAB" stroke-width="1.5" />
							<path
								d="M1.5 15.0647L6.59437 9.96935C6.66403 9.89962 6.74675 9.8443 6.83779 9.80656C6.92884 9.76882 7.02644 9.74939 7.125 9.74939C7.22356 9.74939 7.32116 9.76882 7.41221 9.80656C7.50325 9.8443 7.58597 9.89962 7.65563 9.96935L15.105 17.4187"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path
								d="M12.3105 14.625L14.719 12.2194C14.8596 12.0788 15.0503 11.9999 15.2491 11.9999C15.448 11.9999 15.6387 12.0788 15.7793 12.2194L22.1777 18.6178"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Impact visuel renforcé', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'La rotation à 360° captive l’attention et permet de révéler chaque détail du véhicule, rendant chaque présentation plus immersive et convaincante.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b lg:border-b-0 border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
							aria-hidden="true">
							<path
								d="M21.334 9.95652V3.86957C21.334 3.63894 21.243 3.41777 21.081 3.25469C20.9191 3.09161 20.6994 3 20.4703 3H3.19762C2.96857 3 2.7489 3.09161 2.58694 3.25469C2.42497 3.41777 2.33398 3.63894 2.33398 3.86957V9.95652C2.33398 20.3913 11.834 23 11.834 23C11.834 23 21.334 20.3913 21.334 9.95652Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path d="M7.33398 12.4286L10.034 15L16.334 9" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Durabilité et robustesse', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Fabriqué à partir de matériaux de haute qualité, ce plateau est conçu pour une utilisation intensive et résiste aux conditions les plus exigeantes.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container py-7 lg:pt-9 lg:pb-13 px-1.5 lg:px-0">

				<div class="mb-4 max-w-full w-[814px] text-xl lg:text-2xl font-display">
					<?php echo wp_kses( __( 'Le plateau tournant motorisé Moovcar360° est également polyvalent et s\'adapte à de nombreux usages professionnels', 'moovcar' ), mvc_allowed_html() ); ?>
				</div>

				<?php get_template_part( 'template-parts/block', 'services', array( 'current_page_id' => get_the_id() ) ); ?>
			</div>

		</section>

		<section class="pt-12 lg:pt-24 mb-6 relative z-0">
			<picture class="absolute inset-0 -z-10 overflow-hidden">
				<div
					class="absolute inset-y-0 left-0 w-full lg:w-[57%] bg-gradient-to-r from-green-150/75 to-transparent to-[98%] backdrop-blur-[8px]">
				</div>
				<img class="max-w-none w-[200%] lg:w-full lg:h-full lg:object-cover" width="1200" height="892"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-produit-2.jpg" alt="">
			</picture>

			<div class="container pb-7 px-1.5 lg:px-0 grid grid-cols-12 text-white">
				<div class="col-span-12 lg:col-span-7 xl:col-span-6 2xl:col-span-5">
					<div
						class="mb-3 px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-white rounded-btn text-sm font-display uppercase">
						<span><?php esc_html_e( 'Nos avantages', 'moovcar' ); ?></span>
					</div>
					<h2 class="mb-2 text-2xl font-display">
						<?php echo wp_kses( __( 'Pourquoi choisir les plateaux tournants <span class="whitespace-nowrap">MOOVCAR 360 ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
					<p>
						<?php echo wp_kses( __( 'Les plateaux Moovcar360 sont la référence pour les professionnels de l’automobile, offrant une qualité et une performance incomparables.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-3 translate-y-6 -mt-6">
				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Construction solide et fiable', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Conçu avec des matériaux résistants, Moovcar360 est un plateau tournant conçu pour durer.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Capacité de charge élevée', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à son système motorisé avancé, il supporte des véhicules lourds, des modèles de tourisme aux grosses cylindrées (jusqu\'à 3,5 tonnes).', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Rotation fluide et stable', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à une technologie de rotation perfectionnée, vos prises de vue et présentations bénéficient d’une fluidité sans faille.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>
		</section>

		<section class="container relative px-1.5 lg:px-0 py-10 grid grid-cols-12 gap-1">
			<div class="col-span-12 lg:col-span-6 mb-4 lg:mb-0">
				<div class="lg:sticky lg:top-10">
					<h2 class="max-w-full w-[517px] mx-auto text-2xl font-display">
						<?php echo wp_kses( __( '<span class="text-green-100">Les étapes</span><br> pour obtenir votre plateau tournant en <span class="whitespace-nowrap">toute simplicité</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
				</div>
			</div>
			<div class="col-span-12 lg:col-span-6 mvc-product-steps flex flex-col gap-y-7">

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							1</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Prise de contact', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Remplissez notre formulaire en ligne ou contactez-nous directement pour nous faire part de vos besoins. ', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
						<div class="flex flex-col xl:flex-row items-start gap-0.5">
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="devis"><?php echo wp_kses( __( 'Remplir le formulaire en ligne', 'moovcar' ), mvc_allowed_html() ); ?></button>
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="contact"><?php echo wp_kses( __( 'Contactez-nous', 'moovcar' ), mvc_allowed_html() ); ?></button>
						</div>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							2</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Évaluation de vos besoins', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Notre équipe vous aide à définir les spécifications techniques et le type de plateau tournant motorisé qui correspond à votre projet.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							3</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Proposition de solution personnalisée', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Nous vous proposons une solution sur mesure avec un prix sur demande, adapté à vos contraintes d’espace et d’utilisation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							4</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Achat et livraison', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Finalisez votre achat de plateau tournant voiture en toute simplicité. Nous nous occupons de la livraison et assurons un suivi jusqu\'à l\'installation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

			</div>
		</section>

		<section class="mvc-product-faq pb-7 lg:pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 2xl:col-start-2 2xl:col-end-12">
					<h2 class="mb-4 text-2xl font-display text-center">
						<?php esc_html_e( 'Les questions fréquentes', 'moovcar' ); ?>
					</h2>
					<?php
					$faq_blocks = mvc_find_blocks( parse_blocks( get_the_content() ), 'yoast/faq-block' );

					foreach ( $faq_blocks as $faq_block ) {
						echo $faq_block['innerHTML'];
					}
					?>
				</div>
			</div>
		</section>

		<?php get_template_part( 'template-parts/realisation/content', 'list', array( 'realisation_category_term_id' => 27 ) ); ?>

		<?php get_template_part( 'template-parts/reviews/content', 'list' ); ?>

		<?php get_template_part( 'template-parts/content/content', 'list', array( 'category_id' => 26 ) ); ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();