<?php

/**
 * Template name: Usage / Garage
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="pb-7 lg:pb-10" id="main" role="main">

		<section class="pt-4.5 pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12 gap-y-5">

				<div class="col-span-12 lg:col-span-6">
					<div class="swiper product-images mb-1" data-slides-per-view="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-ferrari.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-audi.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-calais.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-1.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-2.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-3.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-4.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-5.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-6.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-7.jpg"
									alt="">

							</div>
						</div>
					</div>
					<div class="product-thumbs relative px-2">
						<div class="swiper" data-slides-per-view="1">
							<div class="swiper-wrapper">
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-ferrari.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-audi.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-calais.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-1.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-2.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-3.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-4.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-5.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-6.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-tournant-bordeaux-eysines-7.jpg"
										alt="">

								</div>
							</div>
						</div>
						<div class="swiper-navigation">
							<div class="swiper-btn-prev">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M7,14c-.26,0-.51-.1-.71-.29L.29,7.71c-.39-.39-.39-1.02,0-1.41L6.29.29c.39-.39,1.02-.39,1.41,0s.39,1.02,0,1.41L2.41,7l5.29,5.29c.39.39.39,1.02,0,1.41-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
							<div class="swiper-btn-next">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M1,14c-.26,0-.51-.1-.71-.29-.39-.39-.39-1.02,0-1.41l5.29-5.29L.29,1.71C-.1,1.32-.1.68.29.29S1.32-.1,1.71.29l6,6c.39.39.39,1.02,0,1.41L1.71,13.71c-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
						</div>
					</div>
				</div>

				<div class="col-span-12 lg:col-start-8 lg:col-end-13">
					<h1 class="mb-2 text-2xl font-display max-w-full w-[308px]">
						<?php esc_html_e( 'Plateau tournant pour votre garage', 'moovcar' ); ?></h1>
					<p class="mx-auto mb-5">
						<?php echo wp_kses( __( 'Le <span class="font-medium">plateau tournant motorisé pour garage voiture</span> de <span class="font-medium">Moovcar360</span> est conçu pour offrir une solution pratique et efficace aux garages professionnels. Grâce à sa <span class="font-medium">plateforme rotative</span>, ce dispositif permet de <span class="font-medium">tourner les véhicules</span> dans des espaces restreints sans manœuvres complexes.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
					<div class="product-price mb-2 flex justify-between items-center gap-2">
						<span class="text-xl font-display">13 900€ <?php esc_html_e( 'HT', 'moovcar' ); ?></span>
						<button type="button" data-micromodal-trigger="devis"
							class="btn-primary"><?php esc_html_e( 'Obtenir un devis', 'moovcar' ); ?></button>
					</div>
					<div class="product-details accordion-container">
						<div class="ac features">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"
										aria-hidden="true">
										<path d="M9.79297 7.02991H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 7.02991L5.64453 7.62366L7.42578 5.84241" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M9.79297 12.5716H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 12.5716L5.64453 13.1653L7.42578 11.3841" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path
											d="M7.12565 17.4167H11.8757C15.834 17.4167 17.4173 15.8333 17.4173 11.875V7.12499C17.4173 3.16666 15.834 1.58333 11.8757 1.58333H7.12565C3.16732 1.58333 1.58398 3.16666 1.58398 7.12499V11.875C1.58398 15.8333 3.16732 17.4167 7.12565 17.4167Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Caractéristiques', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre du plateau tournant</span> : 430 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec les rampes</span> : 500 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur</span> : 9 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Installation sur un sol plat de 36 m²</span>', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Prise de courant</span> : 220 V standard', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Structure composée de 11 panneaux sandwich en tôle de 2 mm</span>', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Rampes en acier de 3 mm</span> pour une robustesse optimale', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">5 chariots par panneau sandwich</span> assurant une rotation fluide', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">4 moteurs intégrés sous les rampes</span>, avec un système électrique protégé', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Panneau de commande avec régulateur</span> pour un contrôle précis des mouvements', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Deux télécommandes</span> fournies pour une gestion à distance facile', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac dimensions">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path
											d="M17.7188 3.9375V7.875C17.7188 8.04905 17.6496 8.21597 17.5265 8.33904C17.4035 8.46211 17.2365 8.53125 17.0625 8.53125C16.8885 8.53125 16.7215 8.46211 16.5985 8.33904C16.4754 8.21597 16.4062 8.04905 16.4062 7.875V5.52152L12.2768 9.6518C12.1537 9.77494 11.9866 9.84411 11.8125 9.84411C11.6384 9.84411 11.4713 9.77494 11.3482 9.6518C11.2251 9.52866 11.1559 9.36165 11.1559 9.1875C11.1559 9.01335 11.2251 8.84634 11.3482 8.7232L15.4785 4.59375H13.125C12.951 4.59375 12.784 4.52461 12.661 4.40154C12.5379 4.27847 12.4688 4.11155 12.4688 3.9375C12.4688 3.76345 12.5379 3.59653 12.661 3.47346C12.784 3.35039 12.951 3.28125 13.125 3.28125H17.0625C17.2365 3.28125 17.4035 3.35039 17.5265 3.47346C17.6496 3.59653 17.7188 3.76345 17.7188 3.9375ZM8.7232 11.3482L4.59375 15.4785V13.125C4.59375 12.951 4.52461 12.784 4.40154 12.661C4.27847 12.5379 4.11155 12.4688 3.9375 12.4688C3.76345 12.4688 3.59653 12.5379 3.47346 12.661C3.35039 12.784 3.28125 12.951 3.28125 13.125V17.0625C3.28125 17.2365 3.35039 17.4035 3.47346 17.5265C3.59653 17.6496 3.76345 17.7188 3.9375 17.7188H7.875C8.04905 17.7188 8.21597 17.6496 8.33904 17.5265C8.46211 17.4035 8.53125 17.2365 8.53125 17.0625C8.53125 16.8885 8.46211 16.7215 8.33904 16.5985C8.21597 16.4754 8.04905 16.4062 7.875 16.4062H5.52152L9.6518 12.2768C9.77494 12.1537 9.84411 11.9866 9.84411 11.8125C9.84411 11.6384 9.77494 11.4713 9.6518 11.3482C9.52866 11.2251 9.36165 11.1559 9.1875 11.1559C9.01335 11.1559 8.84634 11.2251 8.7232 11.3482Z"
											fill="#2D4140" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Dimensions', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Le plateau tournant pour voiture est conçu pour s’intégrer parfaitement dans les garages grâce à ses dimensions optimales :', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre du plateau</span> : 430 cm, suffisamment large pour accueillir tous types de véhicules, y compris des camions légers.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 500 cm, permettant une rotation complète dans un espace sécurisé.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur</span> : seulement 9 cm, ce qui minimise l’impact visuel dans votre garage tout en garantissant une utilisation pratique.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Surface d’installation</span> : Nécessite un espace de 36 m² et une alimentation standard de 220 V, pour une installation simple et rapide.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac livraison">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path d="M2.77344 6.50995L10.4997 10.9812L18.1734 6.53617" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M10.5 18.909V10.9727" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path
											d="M8.68928 2.17L4.01678 4.76878C2.95803 5.35503 2.0918 6.82501 2.0918 8.03251V12.9763C2.0918 14.1838 2.95803 15.6538 4.01678 16.24L8.68928 18.8388C9.68678 19.39 11.323 19.39 12.3205 18.8388L16.993 16.24C18.0518 15.6538 18.918 14.1838 18.918 12.9763V8.03251C18.918 6.82501 18.0518 5.35503 16.993 4.76878L12.3205 2.17C11.3143 1.61 9.68678 1.61 8.68928 2.17Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
										<path d="M14.8741 11.5851V8.38262L6.57031 3.58759" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Livraison et installation', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<ul>
										<p class="mb-1.5">
											<?php echo wp_kses( __( 'L’installation de votre <span class="font-medium">plateau tournant motorisé</span> est rapide et simple. Sur <span class="font-medium">stock</span>, la livraison et l’installation peuvent être effectuées en <span class="font-medium">10 à 15 jours</span>. Pour les commandes spéciales, le délai est d’environ <span class="font-medium">8 semaines</span>. Notre équipe de techniciens assure une <span class="font-medium">installation professionnelle</span> sur un sol plat, vous garantissant une intégration parfaite du système.', 'moovcar' ), mvc_allowed_html() ); ?>
										</p>
										<p>
											<?php echo wp_kses( __( 'Les <span class="font-medium">frais de livraison et d’installation</span> s’élèvent à <span class="font-medium">2 000 € HT</span> à régler au comptant.', 'moovcar' ), mvc_allowed_html() ); ?>
										</p>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		</section>

		<section class="grid grid-cols-1 lg:grid-cols-2 items-center bg-green-150 text-white">
			<div class="py-5.5 px-1.5 md:px-5.5">
				<h2 class="max-w-full w-[530px] mb-2 text-2xl font-display">
					<?php echo wp_kses( __( 'Pourquoi opter pour un plateau tournant pour voiture <span class="whitespace-nowrap">dans votre garage ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
				</h2>
				<p class="max-w-full w-[530px]">
					<?php echo wp_kses( __( 'Un plateau tournant motorisé est un excellent investissement pour les garages professionnels souhaitant optimiser leur espace et améliorer la gestion des véhicules. Grâce à sa plateforme rotative, ce système permet de tourner les véhicules sans effort et de faciliter les manœuvres dans des espaces restreints. Voici pourquoi :', 'moovcar' ), mvc_allowed_html() ); ?>
				</p>
			</div>
			<picture class="relative h-[400px] lg:h-[677px]">
				<img class="w-full h-full object-cover" width="713" height="677"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/garage/moovcar360-garage-plateau-pourquoi.jpg"
					alt="">
			</picture>
		</section>

		<section class="bg-green-25">

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-3 -translate-y-11 -mb-11">

				<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path d="M15.4512 3.375H20.6261V8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M14.5879 9.41247L20.6254 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M8.54998 20.6249H3.375V15.45" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M9.41247 14.5875L3.375 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M20.6261 15.45V20.6249H15.4512" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M14.5879 14.5875L20.6254 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M3.375 8.54998V3.375H8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M9.41247 9.41247L3.375 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Optimisation de l’espace', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Un plateau tournant permet de maximiser l’utilisation de l’espace dans un garage, particulièrement dans les zones à accès restreint ou avec une grande densité de véhicules.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path
								d="M3 9.75H7.5V19.5H3C2.80109 19.5 2.61032 19.421 2.46967 19.2803C2.32902 19.1397 2.25 18.9489 2.25 18.75V10.5C2.25 10.3011 2.32902 10.1103 2.46967 9.96967C2.61032 9.82902 2.80109 9.75 3 9.75Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path
								d="M7.5 9.75L11.25 2.25C12.0456 2.25 12.8087 2.56607 13.3713 3.12868C13.9339 3.69129 14.25 4.45435 14.25 5.25V7.5H20.25C20.4628 7.50006 20.6731 7.54539 20.867 7.63297C21.0609 7.72056 21.234 7.8484 21.3747 8.008C21.5154 8.1676 21.6206 8.35532 21.6832 8.55868C21.7458 8.76204 21.7644 8.97646 21.7378 9484.6128 18.1875C20.5672 18.5499 20.3908 18.8832 20.1169 19.1249C19.843 19.3665 19.4903 19.4999 19.125 19.5H7.5"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Facilité des manœuvres', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Les garages équipés d’un plateau tournant bénéficient d’une plus grande facilité pour garer ou déplacer les véhicules.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b lg:border-b-0 border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<path
								d="M21.334 9.95652V3.86957C21.334 3.63894 21.243 3.41777 21.081 3.25469C20.9191 3.09161 20.6994 3 20.4703 3H3.19762C2.96857 3 2.7489 3.09161 2.58694 3.25469C2.42497 3.41777 2.33398 3.63894 2.33398 3.86957V9.95652C2.33398 20.3913 11.834 23 11.834 23C11.834 23 21.334 20.3913 21.334 9.95652Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path d="M7.33398 12.4286L10.034 15L16.334 9" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Amélioration de la sécurité', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'En réduisant les manœuvres manuelles, le plateau tournant rotatif diminue les risques d\'accidents dans les zones de stationnement ou d’entretien.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container py-7 lg:pt-9 lg:pb-13 px-1.5 lg:px-0">

				<div class="mb-4 max-w-full w-[814px] text-xl lg:text-2xl font-display">
					<?php echo wp_kses( __( 'Le plateau tournant motorisé Moovcar360° est également polyvalent et s\'adapte à de nombreux usages professionnels', 'moovcar' ), mvc_allowed_html() ); ?>
				</div>

				<?php get_template_part( 'template-parts/block', 'services', array( 'current_page_id' => get_the_id() ) ); ?>
			</div>

		</section>

		<section class="pt-12 lg:pt-24 mb-6 relative z-0">
			<picture class="absolute inset-0 -z-10 overflow-hidden">
				<div
					class="absolute inset-y-0 left-0 w-full lg:w-[57%] bg-gradient-to-r from-green-150/75 to-transparent to-[98%] backdrop-blur-[8px]">
				</div>
				<img class="max-w-none w-[200%] lg:w-full lg:h-full lg:object-cover" width="1920" height="865"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/voiture-pourquoi-choisir.jpg"
					alt="">
			</picture>

			<div class="container pb-7 px-1.5 lg:px-0 grid grid-cols-12 text-white">
				<div class="col-span-12 lg:col-span-7 xl:col-span-6 2xl:col-span-5">
					<div
						class="mb-3 px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-white rounded-btn text-sm font-display uppercase">
						<span><?php esc_html_e( 'Nos avantages', 'moovcar' ); ?></span>
					</div>
					<h2 class="mb-2 text-2xl font-display">
						<?php echo wp_kses( __( 'Pourquoi choisir les plateaux tournants pour voiture <span class="whitespace-nowrap">MOOVCAR 360 ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
					<p>
						<?php echo wp_kses( __( 'Les plateaux tournants Moovcar360 se démarquent par leur qualité de construction et leur adaptabilité aux usages professionnels les plus exigeants :', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-2 translate-y-6 -mt-6">
				<div class="p-3 bg-green-25 border-b lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Qualité et robustesse', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Les plateaux tournants MOOVCAR360 sont fabriqués avec des matériaux durables, garantissant une longue durée de vie même en usage intensif.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Conçus pour les charges lourdes', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Nos systèmes motorisés sont capables de supporter des véhicules lourds, ce qui en fait une solution idéale pour les garages professionnels.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Rotation fluide et précise', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à leur conception rotative avancée, nos plateaux tournants offrent une rotation sans à-coups, facilitant les manœuvres et optimisant l’espace.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Installation simple et efficace', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Nos plateaux tournants sont conçus pour une intégration facile dans tout type de garage, garantissant un gain d’espace optimal avec une installation rapide.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>
		</section>

		<section class="container relative px-1.5 lg:px-0 py-10 grid grid-cols-12 gap-1">
			<div class="col-span-12 lg:col-span-6 mb-4 lg:mb-0">
				<div class="lg:sticky lg:top-10">
					<h2 class="max-w-full w-[517px] mx-auto text-2xl font-display">
						<?php echo wp_kses( __( '<span class="text-green-100">Les étapes</span><br> pour obtenir votre plateau tournant en <span class="whitespace-nowrap">toute simplicité</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
				</div>
			</div>
			<div class="col-span-12 lg:col-span-6 mvc-product-steps flex flex-col gap-y-7">

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							1</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Prise de contact', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Remplissez notre formulaire en ligne ou contactez-nous directement pour nous faire part de vos besoins. ', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
						<div class="flex flex-col xl:flex-row items-start gap-0.5">
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="devis"><?php echo wp_kses( __( 'Remplir le formulaire en ligne', 'moovcar' ), mvc_allowed_html() ); ?></button>
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="contact"><?php echo wp_kses( __( 'Contactez-nous', 'moovcar' ), mvc_allowed_html() ); ?></button>
						</div>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							2</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Évaluation de vos besoins', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Notre équipe vous aide à définir les spécifications techniques et le type de plateau tournant motorisé qui correspond à votre projet.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							3</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Proposition de solution personnalisée', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Nous vous proposons une solution sur mesure avec un prix sur demande, adapté à vos contraintes d’espace et d’utilisation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							4</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Achat et livraison', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Finalisez votre achat de plateau tournant voiture en toute simplicité. Nous nous occupons de la livraison et assurons un suivi jusqu\'à l\'installation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

			</div>
		</section>

		<section class="mvc-product-faq pb-7 lg:pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 2xl:col-start-2 2xl:col-end-12">
					<h2 class="mb-4 text-2xl font-display text-center">
						<?php esc_html_e( 'Les questions fréquentes', 'moovcar' ); ?>
					</h2>
					<?php
					$faq_blocks = mvc_find_blocks( parse_blocks( get_the_content() ), 'yoast/faq-block' );

					foreach ( $faq_blocks as $faq_block ) {
						echo $faq_block['innerHTML'];
					}
					?>
				</div>
			</div>
		</section>

		<?php get_template_part( 'template-parts/realisation/content', 'list', array( 'realisation_category_term_id' => 7 ) ); ?>

		<?php get_template_part( 'template-parts/reviews/content', 'list' ); ?>

		<?php get_template_part( 'template-parts/content/content', 'list', array( 'category_id' => 25 ) ); ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();