<?php
/**
 * Template name: Usage / Moto
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="pb-7 lg:pb-10" id="main" role="main">

		<section class="pt-4.5 pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12 gap-y-5">

				<div class="col-span-12 lg:col-span-6">
					<div class="swiper product-images mb-1" data-slides-per-view="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-1.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-2.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-3.jpg"
									alt="">

							</div>
						</div>
					</div>

					<div class="product-thumbs relative px-2">
						<div class="swiper" data-slides-per-view="1">
							<div class="swiper-wrapper">
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="639" height="479"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-1.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-2.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moovcar360-moto-plateau-tournant-3.jpg"
										alt="">

								</div>
							</div>
						</div>
						<div class="swiper-navigation">
							<div class="swiper-btn-prev">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M7,14c-.26,0-.51-.1-.71-.29L.29,7.71c-.39-.39-.39-1.02,0-1.41L6.29.29c.39-.39,1.02-.39,1.41,0s.39,1.02,0,1.41L2.41,7l5.29,5.29c.39.39.39,1.02,0,1.41-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
							<div class="swiper-btn-next">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M1,14c-.26,0-.51-.1-.71-.29-.39-.39-.39-1.02,0-1.41l5.29-5.29L.29,1.71C-.1,1.32-.1.68.29.29S1.32-.1,1.71.29l6,6c.39.39.39,1.02,0,1.41L1.71,13.71c-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
						</div>
					</div>
				</div>

				<div class="col-span-12 lg:col-start-8 lg:col-end-13">
					<h1 class="mb-2 text-2xl font-display">
						<?php esc_html_e( 'Optez pour un plateau tournant pour moto', 'moovcar' ); ?></h1>
					<p class="mx-auto mb-5">
						<?php esc_html_e( 'Transformez la présentation de vos motos avec le plateau tournant motorisé Moovcar360, conçu pour faciliter les mouvements rotatifs et optimiser l\'espace d\'exposition. Ce plateau assure une rotation fluide et met en valeur chaque détail de vos deux-roues en un simple tour.', 'moovcar' ); ?>
					</p>
					<div class="product-price mb-2 flex justify-between items-center gap-2">
						<span class="text-xl font-display">13 900€ <?php esc_html_e( 'HT', 'moovcar' ); ?></span>
						<button type="button" data-micromodal-trigger="devis"
							class="btn-primary"><?php esc_html_e( 'Obtenir un devis', 'moovcar' ); ?></button>
					</div>
					<div class="product-details accordion-container">
						<div class="ac features">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"
										aria-hidden="true">
										<path d="M9.79297 7.02991H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 7.02991L5.64453 7.62366L7.42578 5.84241" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M9.79297 12.5716H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 12.5716L5.64453 13.1653L7.42578 11.3841" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path
											d="M7.12565 17.4167H11.8757C15.834 17.4167 17.4173 15.8333 17.4173 11.875V7.12499C17.4173 3.16666 15.834 1.58333 11.8757 1.58333H7.12565C3.16732 1.58333 1.58398 3.16666 1.58398 7.12499V11.875C1.58398 15.8333 3.16732 17.4167 7.12565 17.4167Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Caractéristiques', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Le plateau tournant Moovcar360 est conçu pour supporter des charges importantes tout en garantissant une rotation précise et stable. Découvrez ses caractéristiques qui en font un outil indispensable :', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre de la plateforme</span> : 430 cm, suffisamment spacieux pour les motos de tous types, même les plus imposantes.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 500 cm, pour un mouvement rotatif complet permettant une visualisation à 360°.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur</span> : 9 cm, assurant une intégration discrète dans un garage ou un atelier.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Installation</span> : Requiert une surface de 36 m² et un sol plat pour une stabilité parfaite pendant le mouvement rotatif.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Alimentation</span> : Fonctionne avec une prise standard de 220 V, facilement adaptable dans divers lieux d’exposition.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Construction robuste</span> : Composé de 11 panneaux en tôle de 2 mm, ce plateau garantit une durabilité élevée et une stabilité optimale pour la rotation des motos.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Rampes en acier</span> de 3 mm, renforcées pour supporter le poids des motos lourdes et offrir une résistance accrue.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Rotation fluide assurée par 5 chariots par panneau</span>, garantissant des mouvements réguliers sans secousses.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Système motorisé</span> avec 4 moteurs intégrés sous les rampes et un système électrique sécurisé pour une rotation sans à-coups.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Panneau de commande</span> permettant de régler la vitesse de rotation pour s’adapter à chaque présentation.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Deux télécommandes</span> incluses, facilitant le contrôle à distance pour une utilisation flexible et sans effort.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac dimensions">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path
											d="M17.7188 3.9375V7.875C17.7188 8.04905 17.6496 8.21597 17.5265 8.33904C17.4035 8.46211 17.2365 8.53125 17.0625 8.53125C16.8885 8.53125 16.7215 8.46211 16.5985 8.33904C16.4754 8.21597 16.4062 8.04905 16.4062 7.875V5.52152L12.2768 9.6518C12.1537 9.77494 11.9866 9.84411 11.8125 9.84411C11.6384 9.84411 11.4713 9.77494 11.3482 9.6518C11.2251 9.52866 11.1559 9.36165 11.1559 9.1875C11.1559 9.01335 11.2251 8.84634 11.3482 8.7232L15.4785 4.59375H13.125C12.951 4.59375 12.784 4.52461 12.661 4.40154C12.5379 4.27847 12.4688 4.11155 12.4688 3.9375C12.4688 3.76345 12.5379 3.59653 12.661 3.47346C12.784 3.35039 12.951 3.28125 13.125 3.28125H17.0625C17.2365 3.28125 17.4035 3.35039 17.5265 3.47346C17.6496 3.59653 17.7188 3.76345 17.7188 3.9375ZM8.7232 11.3482L4.59375 15.4785V13.125C4.59375 12.951 4.52461 12.784 4.40154 12.661C4.27847 12.5379 4.11155 12.4688 3.9375 12.4688C3.76345 12.4688 3.59653 12.5379 3.47346 12.661C3.35039 12.784 3.28125 12.951 3.28125 13.125V17.0625C3.28125 17.2365 3.35039 17.4035 3.47346 17.5265C3.59653 17.6496 3.76345 17.7188 3.9375 17.7188H7.875C8.04905 17.7188 8.21597 17.6496 8.33904 17.5265C8.46211 17.4035 8.53125 17.2365 8.53125 17.0625C8.53125 16.8885 8.46211 16.7215 8.33904 16.5985C8.21597 16.4754 8.04905 16.4062 7.875 16.4062H5.52152L9.6518 12.2768C9.77494 12.1537 9.84411 11.9866 9.84411 11.8125C9.84411 11.6384 9.77494 11.4713 9.6518 11.3482C9.52866 11.2251 9.36165 11.1559 9.1875 11.1559C9.01335 11.1559 8.84634 11.2251 8.7232 11.3482Z"
											fill="#2D4140" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Dimensions', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'Le <span class="font-medium">plateau tournant Moovcar360</span> est conçu pour s’intégrer facilement dans tout type d’espace, que ce soit pour un garage professionnel, un atelier ou un salon d’exposition. Ses dimensions optimisées offrent une utilisation efficace pour toutes tailles de motos.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre du plateau</span> : 430 cm, idéal pour les motos classiques et les modèles plus grands tels que les Harley Davidson.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 500 cm, permettant une rotation complète dans un espace sécurisé.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur</span> : Avec seulement 9 cm, le plateau s’intègre facilement dans tout environnement sans compromettre l’esthétique.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Surface d’installation</span> : Nécessite un espace de 36 m² et une alimentation standard de 220 V, pour une installation simple et rapide.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac livraison">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path d="M2.77344 6.50995L10.4997 10.9812L18.1734 6.53617" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M10.5 18.909V10.9727" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path
											d="M8.68928 2.17L4.01678 4.76878C2.95803 5.35503 2.0918 6.82501 2.0918 8.03251V12.9763C2.0918 14.1838 2.95803 15.6538 4.01678 16.24L8.68928 18.8388C9.68678 19.39 11.323 19.39 12.3205 18.8388L16.993 16.24C18.0518 15.6538 18.918 14.1838 18.918 12.9763V8.03251C18.918 6.82501 18.0518 5.35503 16.993 4.76878L12.3205 2.17C11.3143 1.61 9.68678 1.61 8.68928 2.17Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
										<path d="M14.8741 11.5851V8.38262L6.57031 3.58759" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Livraison et installation', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<p class="mb-1.5">
										<?php echo wp_kses( __( 'La livraison et l’installation de votre plateau tournant sont rapides et adaptées à vos besoins professionnels. Si le modèle est disponible en stock, vous pouvez en disposer dans un délai de 10 à 15 jours. Pour des commandes spécifiques, le délai peut aller jusqu’à 8 semaines. Notre équipe se charge de fixer le plateau sur un sol plat pour garantir un mouvement rotatif fluide et immédiat.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
									<p>
										<?php echo wp_kses( __( 'Les frais de livraison et d’installation s’élèvent à 2 000 € HT à régler au comptant.', 'moovcar' ), mvc_allowed_html() ); ?>
									</p>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		</section>

		<section class="grid grid-cols-1 lg:grid-cols-2 items-center bg-green-150 text-white">
			<div class="py-5.5 px-1.5 md:px-5.5">
				<h2 class="max-w-full w-[530px] mb-2 text-2xl font-display">
					<?php echo wp_kses( __( 'Pourquoi opter pour un plateau tournant <span class="whitespace-nowrap">pour moto ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
				</h2>
				<p class="max-w-full w-[530px]">
					<?php echo wp_kses( __( 'Le plateau tournant pour moto Moovcar360 est un choix stratégique pour les professionnels souhaitant simplifier la gestion de l’espace et améliorer la présentation de leurs véhicules. Voici pourquoi investir dans un plateau rotatif pour moto peut transformer votre espace de travail :', 'moovcar' ), mvc_allowed_html() ); ?>
				</p>
			</div>
			<picture class="relative h-[400px] lg:h-[677px]">
				<img class="w-full h-full object-cover" width="900" height="677"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moto-pourquoi-opter.jpg" alt="">
			</picture>
		</section>

		<section class="bg-green-25">

			<div class="container px-1.5 lg:px-0 -translate-y-11 -mb-11">

				<div class="grid grid-cols-1 lg:grid-cols-3">
					<div class="p-3 bg-white border-b lg:border-r border-foreground/25">
						<figure class="mb-1 w-[24px] h-[24px] flex items-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
								aria-hidden="true">
								<path d="M15.4512 3.375H20.6261V8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M14.5879 9.41247L20.6254 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M8.54998 20.6249H3.375V15.45" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M9.41247 14.5875L3.375 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M20.6261 15.45V20.6249H15.4512" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M14.5879 14.5875L20.6254 20.625" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M3.375 8.54998V3.375H8.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M9.41247 9.41247L3.375 3.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
							</svg>
						</figure>
						<h3 class="mb-1.5 text-lg font-display">
							<?php echo wp_kses( __( 'Optimisation de l’espace', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p>
							<?php echo wp_kses( __( 'Ce plateau rotatif permet de gérer efficacement les petites surfaces, facilitant les manœuvres et les déplacements de moto sans effort.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>

					<div class="p-3 bg-white border-b lg:border-r border-foreground/25">
						<figure class="mb-1 w-[24px] h-[24px] flex items-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
								aria-hidden="true">
								<path
									d="M3.49945 20.4999C4.32945 21.3299 5.66945 21.3299 6.49945 20.4999L19.4995 7.49994C20.3295 6.66994 20.3295 5.32994 19.4995 4.49994C18.6695 3.66994 17.3295 3.66994 16.4995 4.49994L3.49945 17.4999C2.66945 18.3299 2.66945 19.6699 3.49945 20.4999Z"
									stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M18.0098 8.98999L15.0098 5.98999" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M8.5 2.44L10 2L9.56 3.5L10 5L8.5 4.56L7 5L7.44 3.5L7 2L8.5 2.44Z" stroke="#11DAAB"
									stroke-linecap="round" stroke-linejoin="round" />
								<path d="M4.5 8.44L6 8L5.56 9.5L6 11L4.5 10.56L3 11L3.44 9.5L3 8L4.5 8.44Z" stroke="#11DAAB"
									stroke-linecap="round" stroke-linejoin="round" />
								<path d="M19.5 13.44L21 13L20.56 14.5L21 16L19.5 15.56L18 16L18.44 14.5L18 13L19.5 13.44Z"
									stroke="#11DAAB" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						</figure>
						<h3 class="mb-1.5 text-lg font-display">
							<?php echo wp_kses( __( 'Valorisation de vos motos', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p>
							<?php echo wp_kses( __( 'En exposant chaque moto sous tous les angles, vous offrez à vos clients une expérience immersive et engageante, idéale pour les salons ou les expositions.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>

					<div class="p-3 bg-white border-b border-foreground/25">
						<figure class="mb-1 w-[24px] h-[24px] flex items-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
								aria-hidden="true">
								<path
									d="M3 9.75H7.5V19.5H3C2.80109 19.5 2.61032 19.421 2.46967 19.2803C2.32902 19.1397 2.25 18.9489 2.25 18.75V10.5C2.25 10.3011 2.32902 10.1103 2.46967 9.96967C2.61032 9.82902 2.80109 9.75 3 9.75Z"
									stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path
									d="M7.5 9.75L11.25 2.25C12.0456 2.25 12.8087 2.56607 13.3713 3.12868C13.9339 3.69129 14.25 4.45435 14.25 5.25V7.5H20.25C20.4628 7.50006 20.6731 7.54539 20.867 7.63297C21.0609 7.72056 21.234 7.8484 21.3747 8.008C21.5154 8.1676 21.6206 8.35532 21.6832 8.55868C21.7458 8.76204 21.7644 8.97639 21.7378 9.1875L20.6128 18.1875C20.5672 18.5499 20.3908 18.8832 20.1169 19.1249C19.843 19.3665 19.4903 19.4999 19.125 19.5H7.5"
									stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						</figure>
						<h3 class="mb-1.5 text-lg font-display">
							<?php echo wp_kses( __( 'Facilité d’utilisation', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p>
							<?php echo wp_kses( __( 'Avec ses télécommandes et son panneau de commande, le plateau tournant Moovcar360 permet de régler la vitesse et le sens de rotation, pour une présentation fluide et professionnelle.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="grid grid-cols-1 lg:grid-cols-2">
					<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
						<figure class="mb-1 w-[24px] h-[24px] flex items-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
								aria-hidden="true">
								<path
									d="M21.334 9.95652V3.86957C21.334 3.63894 21.243 3.41777 21.081 3.25469C20.9191 3.09161 20.6994 3 20.4703 3H3.19762C2.96857 3 2.7489 3.09161 2.58694 3.25469C2.42497 3.41777 2.33398 3.63894 2.33398 3.86957V9.95652C2.33398 20.3913 11.834 23 11.834 23C11.834 23 21.334 20.3913 21.334 9.95652Z"
									stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M7.33398 12.4286L10.034 15L16.334 9" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
							</svg>
						</figure>
						<h3 class="mb-1.5 text-lg font-display">
							<?php echo wp_kses( __( 'Sécurité et stabilité', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p>
							<?php echo wp_kses( __( 'Conçu pour supporter des poids lourds, ce plateau offre une grande stabilité, ce qui le rend idéal pour les modèles volumineux ou les motos de collection.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>

					<div class="p-3 bg-white">
						<figure class="mb-1 w-[24px] h-[24px] flex items-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
								aria-hidden="true">
								<path d="M11 7V12.3333L15 15" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M18 9.5H22.5V5" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path
									d="M17.9368 19.2732C16.5011 20.6221 14.6979 21.5198 12.7526 21.8542C10.8073 22.1886 8.80622 21.9448 6.99928 21.1534C5.19235 20.3619 3.65973 19.0578 2.59293 17.4041C1.52612 15.7504 0.97244 13.8203 1.00106 11.855C1.02967 9.88979 1.63932 7.97651 2.75382 6.35426C3.86833 4.732 5.43827 3.47272 7.26749 2.73374C9.0967 1.99476 11.1041 1.80886 13.0388 2.19927C14.9735 2.58967 16.7498 3.53908 18.1457 4.92885C19.4891 6.28339 20.5984 7.56066 22 9.27316"
									stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>
						</figure>
						<h3 class="mb-1.5 text-lg font-display">
							<?php echo wp_kses( __( 'Gagnez du temps', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p>
							<?php echo wp_kses( __( 'Évitez les efforts manuels et les manœuvres répétitives. Le plateau tournant permet de placer rapidement la moto en position de présentation, en réduisant les temps de manipulation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>
			</div>

			<div class="container py-7 lg:pt-9 lg:pb-13 px-1.5 lg:px-0">

				<div class="mb-4 max-w-full w-[814px] text-xl lg:text-2xl font-display">
					<?php echo wp_kses( __( 'Le plateau tournant motorisé Moovcar360° est également polyvalent et s\'adapte à de nombreux usages professionnels', 'moovcar' ), mvc_allowed_html() ); ?>
				</div>

				<?php get_template_part( 'template-parts/block', 'services', array( 'current_page_id' => get_the_id() ) ); ?>
			</div>

		</section>

		<section class="pt-12 lg:pt-24 mb-6 relative z-0">
			<picture class="absolute inset-0 -z-10 overflow-hidden">
				<div
					class="absolute inset-y-0 left-0 w-full lg:w-[57%] bg-gradient-to-r from-green-150/75 to-transparent to-[98%] backdrop-blur-[8px]">
				</div>
				<img class="max-w-none w-[200%] lg:w-full lg:h-full lg:object-cover" width="1920" height="865"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moto/moto-pourquoi-choisir.jpg" alt="">
			</picture>

			<div class="container pb-7 px-1.5 lg:px-0 grid grid-cols-12 text-white">
				<div class="col-span-12 lg:col-span-7 xl:col-span-6 2xl:col-span-5">
					<div
						class="mb-3 px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-white rounded-btn text-sm font-display uppercase">
						<span><?php esc_html_e( 'Nos avantages', 'moovcar' ); ?></span>
					</div>
					<h2 class="mb-2 text-2xl font-display">
						<?php echo wp_kses( __( 'Pourquoi choisir les plateaux tournants pour moto <span class="whitespace-nowrap">MOOVCAR 360 ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
					<p>
						<?php echo wp_kses( __( 'Les plateaux tournants Moovcar360 se démarquent par leur qualité de construction et leur adaptabilité aux usages professionnels les plus exigeants :', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-2 translate-y-6 -mt-6">
				<div class="p-3 bg-green-25 border-b lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Construction robuste et fiable', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Fabriqués avec des matériaux de haute qualité, nos plateaux sont conçus pour durer, même avec une utilisation intensive.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Capacité de charge élevée', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Le système motorisé est conçu pour soutenir des poids importants, parfait pour les motos lourdes, les motos de tourisme et autres modèles imposants.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Rotation stable et sans à-coups', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à une technologie de rotation avancée, notre plateau tournant assure une rotation fluide pour des prises de vue ou des présentations sans défaut.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Installation simple et rapide', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Les plateaux Moovcar360 s’intègrent facilement dans les garages, studios ou espaces d’exposition, optimisant l’espace sans compromettre la facilité d’utilisation.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>
		</section>

		<section class="container relative px-1.5 lg:px-0 py-10 grid grid-cols-12 gap-1">
			<div class="col-span-12 lg:col-span-6 mb-4 lg:mb-0">
				<div class="lg:sticky lg:top-10">
					<h2 class="max-w-full w-[517px] mx-auto text-2xl font-display">
						<?php echo wp_kses( __( '<span class="text-green-100">Les étapes</span><br> pour obtenir votre plateau tournant en <span class="whitespace-nowrap">toute simplicité</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
				</div>
			</div>
			<div class="col-span-12 lg:col-span-6 mvc-product-steps flex flex-col gap-y-7">

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							1</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Prise de contact', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Remplissez notre formulaire en ligne ou contactez-nous directement pour nous faire part de vos besoins. ', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
						<div class="flex flex-col xl:flex-row items-start gap-0.5">
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="devis"><?php echo wp_kses( __( 'Remplir le formulaire en ligne', 'moovcar' ), mvc_allowed_html() ); ?></button>
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="contact"><?php echo wp_kses( __( 'Contactez-nous', 'moovcar' ), mvc_allowed_html() ); ?></button>
						</div>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							2</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Évaluation de vos besoins', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Notre équipe vous aide à définir les spécifications techniques et le type de plateau tournant motorisé qui correspond à votre projet.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							3</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Proposition de solution personnalisée', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Nous vous proposons une solution sur mesure avec un prix sur demande, adapté à vos contraintes d’espace et d’utilisation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							4</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Achat et livraison', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Finalisez votre achat de plateau tournant voiture en toute simplicité. Nous nous occupons de la livraison et assurons un suivi jusqu\'à l\'installation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

			</div>
		</section>

		<section class="mvc-product-faq pb-7 lg:pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 2xl:col-start-2 2xl:col-end-12">
					<h2 class="mb-4 text-2xl font-display text-center">
						<?php esc_html_e( 'Les questions fréquentes', 'moovcar' ); ?>
					</h2>
					<?php
					$faq_blocks = mvc_find_blocks( parse_blocks( get_the_content() ), 'yoast/faq-block' );

					foreach ( $faq_blocks as $faq_block ) {
						echo $faq_block['innerHTML'];
					}
					?>
				</div>
			</div>
		</section>

		<?php get_template_part( 'template-parts/realisation/content', 'list', array( 'realisation_category_term_id' => 6 ) ); ?>

		<?php get_template_part( 'template-parts/reviews/content', 'list' ); ?>

		<?php get_template_part( 'template-parts/content/content', 'list', array( 'category_id' => 11 ) ); ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();