<?php
/**
 * Template name: Usage / Voiture
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

get_header();
?>

<section id="primary">
	<main class="pb-7 lg:pb-10" id="main" role="main">

		<section class="pt-4.5 pb-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12 gap-y-5">

				<div class="col-span-12 lg:col-span-6">
					<div class="swiper product-images mb-1" data-slides-per-view="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/plateau-tournant-voiture-ferrari.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-bmw.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ferrari-noire.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-cars-and-bikes.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-bymycar-lyon.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ideal-auto.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
									alt="">

							</div>
							<div class="swiper-slide">

								<img class="w-full rounded-md" width="646" height="484"
									src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ewigo.jpg"
									alt="">

							</div>
						</div>
					</div>

					<div class="product-thumbs relative px-2">
						<div class="swiper" data-slides-per-view="1">
							<div class="swiper-wrapper">
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/moovcar360-produit-plateau-tournant.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/plateau-tournant-voiture-ferrari.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-bmw.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ferrari-noire.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-cars-and-bikes.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-bymycar-lyon.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ideal-auto.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-roncq-encastre.jpg"
										alt="">

								</div>
								<div class="swiper-slide w-[95px] h-[95px] rounded-md overflow-hidden">

									<img class="w-full h-full object-cover" width="646" height="484"
										src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/moovcar360-voiture-plateau-tournant-ewigo.jpg"
										alt="">

								</div>
							</div>
						</div>
						<div class="swiper-navigation">
							<div class="swiper-btn-prev">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M7,14c-.26,0-.51-.1-.71-.29L.29,7.71c-.39-.39-.39-1.02,0-1.41L6.29.29c.39-.39,1.02-.39,1.41,0s.39,1.02,0,1.41L2.41,7l5.29,5.29c.39.39.39,1.02,0,1.41-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
							<div class="swiper-btn-next">
								<svg class="fill-green-150" width="8" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 14">
									<path
										d="M1,14c-.26,0-.51-.1-.71-.29-.39-.39-.39-1.02,0-1.41l5.29-5.29L.29,1.71C-.1,1.32-.1.68.29.29S1.32-.1,1.71.29l6,6c.39.39.39,1.02,0,1.41L1.71,13.71c-.2.2-.45.29-.71.29Z" />
								</svg>
							</div>
						</div>
					</div>
				</div>

				<div class="col-span-12 lg:col-start-8 lg:col-end-13">
					<h1 class="mb-2 text-2xl font-display max-w-full w-[308px]">
						<?php esc_html_e( 'Plateau tournant pour voiture', 'moovcar' ); ?></h1>
					<p class="mx-auto mb-5">
						<?php esc_html_e( 'Le plateau tournant motorisé surélevé pour voiture Moovcar360 offre une solution robuste. Idéal pour garages et showrooms, il permet une rotation précise des véhicules et s’adapte à tout type d’installation.', 'moovcar' ); ?>
					</p>
					<div class="product-price mb-2 flex justify-between items-center gap-2">
						<div class="text-xl font-display">
							285€ <?php esc_html_e( 'HT / mois', 'moovcar' ); ?>
							<div class="text-xs uppercase"><?php esc_html_e( 'pendant 60 mois*', 'moovcar' ); ?></div>
						</div>
						<button type="button" data-micromodal-trigger="devis"
							class="btn-primary"><?php esc_html_e( 'Obtenir un devis', 'moovcar' ); ?></button>
					</div>
					<div class="product-details mb-2.5 accordion-container">
						<div class="ac features">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"
										aria-hidden="true">
										<path d="M9.79297 7.02991H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 7.02991L5.64453 7.62366L7.42578 5.84241" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M9.79297 12.5716H13.9492" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path d="M5.05078 12.5716L5.64453 13.1653L7.42578 11.3841" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path
											d="M7.12565 17.4167H11.8757C15.834 17.4167 17.4173 15.8333 17.4173 11.875V7.12499C17.4173 3.16666 15.834 1.58333 11.8757 1.58333H7.12565C3.16732 1.58333 1.58398 3.16666 1.58398 7.12499V11.875C1.58398 15.8333 3.16732 17.4167 7.12565 17.4167Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Caractéristiques', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Plateau composé de 11 panneaux en tôle d\'acier de 2 mm</span> : robustesse et stabilité accrues.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Tôles des rampes en acier de 3 mm</span> : pour une meilleure résistance aux charges lourdes.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">5 roulettes/chariots par panneau</span> : garantissant un mouvement fluide et une rotation précise. ', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">4 moteurs intégrés sous les rampes</span> : système motorisé puissant et discret pour une rotation optimale.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Système électrique intégré sous les rampes</span> : câblage sécurisé pour un fonctionnement sans encombre.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Couleur gris</span> : finition sobre et moderne, idéale pour tout environnement professionnel.', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Panneau de commande avec régulateur</span> : contrôle facile et précis des rotations. régulateur de vitesse ', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Deux télécommandes incluses</span> : pour une gestion à distance pratique et intuitive.	', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac dimensions">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path
											d="M17.7188 3.9375V7.875C17.7188 8.04905 17.6496 8.21597 17.5265 8.33904C17.4035 8.46211 17.2365 8.53125 17.0625 8.53125C16.8885 8.53125 16.7215 8.46211 16.5985 8.33904C16.4754 8.21597 16.4062 8.04905 16.4062 7.875V5.52152L12.2768 9.6518C12.1537 9.77494 11.9866 9.84411 11.8125 9.84411C11.6384 9.84411 11.4713 9.77494 11.3482 9.6518C11.2251 9.52866 11.1559 9.36165 11.1559 9.1875C11.1559 9.01335 11.2251 8.84634 11.3482 8.7232L15.4785 4.59375H13.125C12.951 4.59375 12.784 4.52461 12.661 4.40154C12.5379 4.27847 12.4688 4.11155 12.4688 3.9375C12.4688 3.76345 12.5379 3.59653 12.661 3.47346C12.784 3.35039 12.951 3.28125 13.125 3.28125H17.0625C17.2365 3.28125 17.4035 3.35039 17.5265 3.47346C17.6496 3.59653 17.7188 3.76345 17.7188 3.9375ZM8.7232 11.3482L4.59375 15.4785V13.125C4.59375 12.951 4.52461 12.784 4.40154 12.661C4.27847 12.5379 4.11155 12.4688 3.9375 12.4688C3.76345 12.4688 3.59653 12.5379 3.47346 12.661C3.35039 12.784 3.28125 12.951 3.28125 13.125V17.0625C3.28125 17.2365 3.35039 17.4035 3.47346 17.5265C3.59653 17.6496 3.76345 17.7188 3.9375 17.7188H7.875C8.04905 17.7188 8.21597 17.6496 8.33904 17.5265C8.46211 17.4035 8.53125 17.2365 8.53125 17.0625C8.53125 16.8885 8.46211 16.7215 8.33904 16.5985C8.21597 16.4754 8.04905 16.4062 7.875 16.4062H5.52152L9.6518 12.2768C9.77494 12.1537 9.84411 11.9866 9.84411 11.8125C9.84411 11.6384 9.77494 11.4713 9.6518 11.3482C9.52866 11.2251 9.36165 11.1559 9.1875 11.1559C9.01335 11.1559 8.84634 11.2251 8.7232 11.3482Z"
											fill="#2D4140" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Dimensions', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre du plateau tournant</span> : 430 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Diamètre total avec rampes</span> : 500 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Hauteur du plateau</span> : 9 cm', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>

						<div class="ac livraison">
							<button type="button" class="ac-header ac-trigger">
								<figure class="w-[31px] h-[31px] flex items-center justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<path d="M2.77344 6.50995L10.4997 10.9812L18.1734 6.53617" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
										<path d="M10.5 18.909V10.9727" stroke="#2D4140" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round" />
										<path
											d="M8.68928 2.17L4.01678 4.76878C2.95803 5.35503 2.0918 6.82501 2.0918 8.03251V12.9763C2.0918 14.1838 2.95803 15.6538 4.01678 16.24L8.68928 18.8388C9.68678 19.39 11.323 19.39 12.3205 18.8388L16.993 16.24C18.0518 15.6538 18.918 14.1838 18.918 12.9763V8.03251C18.918 6.82501 18.0518 5.35503 16.993 4.76878L12.3205 2.17C11.3143 1.61 9.68678 1.61 8.68928 2.17Z"
											stroke="#2D4140" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
										<path d="M14.8741 11.5851V8.38262L6.57031 3.58759" stroke="#2D4140" stroke-width="1.5"
											stroke-linecap="round" stroke-linejoin="round" />
									</svg>
								</figure>
								<h2><?php esc_html_e( 'Livraison et installation', 'moovcar' ); ?></h2>
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none"
										aria-hidden="true">
										<circle class="stroke-green-150" cx="10.5" cy="10.5" r="9.5" />
										<path class="stroke-green-150" d="M7 9.5L10.5 13L14 9.5" stroke-linecap="square"
											stroke-linejoin="bevel" />
									</svg>
								</div>
							</button>
							<div class="ac-panel">
								<div class="ac-panel-inner entry-content">
									<ul>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Surface d\'installation requise</span> : 36 m² sur un sol plat en intérieur', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( 'Accès à une <span class="font-medium">prise de courant standard</span> 220 V', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Livraison et montage</span> réalisés par l\'équipe de MOOVCAR', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Temps d\'installation</span> : une journée', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( 'Partout <span class="font-medium">en France et en Belgique</span>', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Frais de livraison et installation</span> : 2000€ HT à régler au comptant', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( 'Garantie pièce et main d’oeuvre', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
										<li>
											<?php echo wp_kses( __( '<span class="font-medium">Délai de livraison et installation</span> : 10 à 15 jours (sur stock) / 8 semaines sur commande', 'moovcar' ), mvc_allowed_html() ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<div>
						<p>
							<?php esc_html_e('*Sous réserve d’acceptation du dossier par LOCAM SAS - Société de financement agréée par l’Autorité de Contrôle Prudentiel et de Résolution. Contrat de location longue durée de 60 mois, réservé aux professionnels. Frais d’installation et de livraison de 2 000 € HT à régler comptant. Voir conditions avec le vendeur.', 'moovcar'); ?>
						</p>
					</div>
				</div>

			</div>
		</section>

		<section class="grid grid-cols-1 lg:grid-cols-2 items-center bg-green-150 text-white">
			<div class="py-5.5 px-1.5 md:px-5.5">
				<h2 class="max-w-full w-[530px] mb-2 text-2xl font-display">
					<?php echo wp_kses( __( 'Pourquoi opter pour un plateau tournant <span class="whitespace-nowrap">pour voiture ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
				</h2>
				<p class="max-w-full w-[530px]">
					<?php echo wp_kses( __( 'Les plateaux tournants motorisés proposés par Moovcar360 sont des solutions innovantes et efficaces, particulièrement utiles pour les concessions automobiles. Voici pourquoi choisir un plateau tournant pour voiture est un atout pour vos espaces professionnels :', 'moovcar' ), mvc_allowed_html() ); ?>
				</p>
			</div>
			<picture class="relative h-[400px] lg:h-[677px]">
				<img class="w-full h-full object-cover" width="713" height="677"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-plateau-pourquoi.jpg" alt="">
			</picture>
		</section>

		<section class="bg-green-25">

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-3 -translate-y-11 -mb-11">

				<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg class="h-full" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
							fill="none" aria-hidden="true">
							<path
								d="M3.49945 20.4999C4.32945 21.3299 5.66945 21.3299 6.49945 20.4999L19.4995 7.49994C20.3295 6.66994 20.3295 5.32994 19.4995 4.49994C18.6695 3.66994 17.3295 3.66994 16.4995 4.49994L3.49945 17.4999C2.66945 18.3299 2.66945 19.6699 3.49945 20.4999Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path d="M18.0098 8.98999L15.0098 5.98999" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M8.5 2.44L10 2L9.56 3.5L10 5L8.5 4.56L7 5L7.44 3.5L7 2L8.5 2.44Z" stroke="#11DAAB"
								stroke-linecap="round" stroke-linejoin="round" />
							<path d="M4.5 8.44L6 8L5.56 9.5L6 11L4.5 10.56L3 11L3.44 9.5L3 8L4.5 8.44Z" stroke="#11DAAB"
								stroke-linecap="round" stroke-linejoin="round" />
							<path d="M19.5 13.44L21 13L20.56 14.5L21 16L19.5 15.56L18 16L18.44 14.5L18 13L19.5 13.44Z"
								stroke="#11DAAB" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Mise en valeur des véhicules', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à une plateforme tournante, chaque véhicule peut être exposé sous tous ses angles, offrant une vue à 360° sans déplacer manuellement la voiture. Cela améliore l\'expérience client et optimise la présentation dans votre showroom.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white border-b lg:border-b-0 lg:border-r border-foreground/25">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"
							aria-hidden="true">
							<path d="M13.7422 1.375H18.9172V6.54998" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M12.8789 7.41247L18.9164 1.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M6.84099 18.6249H1.66602V13.45" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M7.70349 12.5874L1.66602 18.6249" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M18.9172 13.45V18.6249H13.7422" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M12.8789 12.5874L18.9164 18.6249" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M1.66602 6.54998V1.375H6.84099" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M7.70349 7.41247L1.66602 1.375" stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Gain d’espace', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Dans les garages ou les showrooms où l’espace est limité, un plateau tournant motorisé pour voiture permet une rotation fluide, évitant les manœuvres difficiles et maximisant l’utilisation de l’espace disponible.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-white">
					<figure class="mb-1 w-[24px] h-[24px] flex items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="17" viewBox="0 0 20 17" fill="none"
							aria-hidden="true">
							<path
								d="M1.99746 7.63477H5.97832V16.26H1.99746C1.8215 16.26 1.65274 16.1901 1.52831 16.0656C1.40389 15.9412 1.33398 15.7724 1.33398 15.5965V8.29824C1.33398 8.12228 1.40389 7.95352 1.52831 7.82909C1.65274 7.70467 1.8215 7.63477 1.99746 7.63477Z"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							<path
								d="M5.97852 7.63476L9.2959 1C9.99975 1 10.6748 1.27961 11.1725 1.77731C11.6702 2.27501 11.9498 2.95004 11.9498 3.6539V5.64433H17.2576C17.4458 5.64438 17.6319 5.68448 17.8034 5.76196C17.975 5.83945 18.1281 5.95254 18.2526 6.09373C18.3771 6.23492 18.4701 6.40098 18.5255 6.58088C18.5808 6.76078 18.5973 6.9504 18.5738 7.13715L17.5786 15.0989C17.5382 15.4195 17.3822 15.7143 17.1399 15.9281C16.8975 16.1419 16.5855 16.2599 16.2624 16.2599H5.97852"
								stroke="#11DAAB" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					</figure>
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Manoeuvres simplifiées', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Avec un plateau tournant motorisé, les déplacements sont plus précis et la rotation des véhicules est simplifiée, garantissant une mise en scène parfaite pour chaque présentation automobile.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container py-7 lg:pt-9 lg:pb-13 px-1.5 lg:px-0">

				<div class="mb-4 max-w-full w-[814px] text-xl lg:text-2xl font-display">
					<?php echo wp_kses( __( 'Le plateau tournant motorisé Moovcar360° est également polyvalent et s\'adapte à de nombreux usages professionnels', 'moovcar' ), mvc_allowed_html() ); ?>
				</div>

				<?php get_template_part( 'template-parts/block', 'services', array( 'current_page_id' => get_the_id() ) ); ?>
			</div>

		</section>

		<section class="pt-12 lg:pt-24 mb-6 relative z-0">
			<picture class="absolute inset-0 -z-10 overflow-hidden">
				<div
					class="absolute inset-y-0 left-0 w-full lg:w-[57%] bg-gradient-to-r from-green-150/75 to-transparent to-[98%] backdrop-blur-[8px]">
				</div>
				<img class="max-w-none w-[200%] lg:w-full lg:h-full lg:object-cover" width="1920" height="865"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/usages/voiture/voiture-pourquoi-choisir.jpg"
					alt="">
			</picture>

			<div class="container pb-7 px-1.5 lg:px-0 grid grid-cols-12 text-white">
				<div class="col-span-12 lg:col-span-7 xl:col-span-6 2xl:col-span-5">
					<div
						class="mb-3 px-1 py-0.5 inline-flex items-center gap-x-0.75 border border-white rounded-btn text-sm font-display uppercase">
						<span><?php esc_html_e( 'Nos avantages', 'moovcar' ); ?></span>
					</div>
					<h2 class="mb-2 text-2xl font-display">
						<?php echo wp_kses( __( 'Pourquoi choisir les plateaux tournants pour voiture <span class="whitespace-nowrap">MOOVCAR 360 ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
					<p>
						<?php echo wp_kses( __( 'Les plateaux tournants motorisés pour voiture de Moovcar360 offrent des <span class="whitespace-nowrap">solutions robustes</span> et performantes, adaptées aux professionnels de l’automobile.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>

			<div class="container px-1.5 lg:px-0 grid grid-cols-1 lg:grid-cols-3 translate-y-6 -mt-6">
				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Robustesse et capacité à supporter des charges lourdes', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Conçus pour supporter des véhicules de toutes tailles, nos plateaux tournants garantissent une utilisation durable grâce à des matériaux de haute qualité, comme l\'acier.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25 border-b lg:border-b-0 lg:border-r border-foreground/25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Systèmes motorisés<br> performants', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Équipés de moteurs intégrés, nos plateaux tournants offrent une rotation fluide et sans effort, parfaite pour la présentation ou le déplacement de véhicules.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>

				<div class="p-3 bg-green-25">
					<h3 class="mb-1.5 text-lg font-display">
						<?php echo wp_kses( __( 'Fabrication experte pour une durabilité optimale', 'moovcar' ), mvc_allowed_html() ); ?>
					</h3>
					<p>
						<?php echo wp_kses( __( 'Grâce à notre expertise en fabrication, chaque plateforme tournante est conçue pour résister à un usage intensif tout en maintenant des performances élevées.', 'moovcar' ), mvc_allowed_html() ); ?>
					</p>
				</div>
			</div>
		</section>

		<section class="container relative px-1.5 lg:px-0 py-10 grid grid-cols-12 gap-1">
			<div class="col-span-12 lg:col-span-6 mb-4 lg:mb-0">
				<div class="lg:sticky lg:top-10">
					<h2 class="max-w-full w-[517px] mx-auto text-2xl font-display">
						<?php echo wp_kses( __( '<span class="text-green-100">Les étapes</span><br> pour obtenir votre plateau tournant en <span class="whitespace-nowrap">toute simplicité</span>', 'moovcar' ), mvc_allowed_html() ); ?>
					</h2>
				</div>
			</div>
			<div class="col-span-12 lg:col-span-6 mvc-product-steps flex flex-col gap-y-7">

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							1</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Prise de contact', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Remplissez notre formulaire en ligne ou contactez-nous directement pour nous faire part de vos besoins. ', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
						<div class="flex flex-col xl:flex-row items-start gap-0.5">
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="devis"><?php echo wp_kses( __( 'Remplir le formulaire en ligne', 'moovcar' ), mvc_allowed_html() ); ?></button>
							<button type="button" class="btn-primary --simple"
								data-micromodal-trigger="contact"><?php echo wp_kses( __( 'Contactez-nous', 'moovcar' ), mvc_allowed_html() ); ?></button>
						</div>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							2</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Évaluation de vos besoins', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Notre équipe vous aide à définir les spécifications techniques et le type de plateau tournant motorisé qui correspond à votre projet.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							3</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Proposition de solution personnalisée', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Nous vous proposons une solution sur mesure avec un prix sur demande, adapté à vos contraintes d’espace et d’utilisation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

				<div class="mvc-product-step flex gap-x-2 md:gap-x-3">
					<div
						class="step-number shrink-0 relative flex items-center justify-center w-[60px] md:w-[77px] h-[60px] md:h-[77px] border border-foreground rounded-full text-lg md:text-xl font-display text-white opacity-10">
						<div
							class="flex items-center justify-center w-[46px] md:w-[63px] h-[46px] md:h-[63px] bg-foreground rounded-full">
							4</div>
					</div>
					<div>
						<h3 class="mb-1 text-xl font-display">
							<?php echo wp_kses( __( 'Achat et livraison', 'moovcar' ), mvc_allowed_html() ); ?>
						</h3>
						<p class="mb-1.5">
							<?php echo wp_kses( __( 'Finalisez votre achat de plateau tournant voiture en toute simplicité. Nous nous occupons de la livraison et assurons un suivi jusqu\'à l\'installation.', 'moovcar' ), mvc_allowed_html() ); ?>
						</p>
					</div>
				</div>

			</div>
		</section>

		<?php get_template_part( 'template-parts/block', 'encastre' ); ?>

		<section class="mvc-product-faq py-7 lg:py-10">
			<div class="container px-1.5 lg:px-0 grid grid-cols-12">
				<div class="col-span-12 2xl:col-start-2 2xl:col-end-12">
					<h2 class="mb-4 text-2xl font-display text-center">
						<?php esc_html_e( 'Les questions fréquentes', 'moovcar' ); ?>
					</h2>
					<?php
					$faq_blocks = mvc_find_blocks( parse_blocks( get_the_content() ), 'yoast/faq-block' );

					foreach ( $faq_blocks as $faq_block ) {
						echo $faq_block['innerHTML'];
					}
					?>
				</div>
			</div>
		</section>

		<?php get_template_part( 'template-parts/realisation/content', 'list', array( 'realisation_category_term_id' => 5 ) ); ?>

		<?php get_template_part( 'template-parts/reviews/content', 'list' ); ?>

		<?php get_template_part( 'template-parts/content/content', 'list', array( 'category_id' => 10 ) ); ?>

	</main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();