<?php
/**
 * Bloc / Services
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

if ( get_permalink( 226 ) ) : ?>
<section class="container grid lg:grid-cols-2 items-center bg-green-150 text-white">
	<picture class="relative h-full">
		<img class="w-full h-full object-cover" width="647" height="565"
			src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-plateau-encastre.jpg" alt="">
	</picture>
	<div class="py-5 xl:py-7 2xl:py-9 px-3 xl:px-6 2xl:px-8">
		<h3 class="mb-2.5 text-2xl font-display">
			<?php echo wp_kses( __( 'Intéressé par une installation <span class="whitespace-nowrap">encastrée ?</span>', 'moovcar' ), mvc_allowed_html() ); ?>
		</h3>
		<p class="mb-4">
			<?php echo wp_kses( __( 'Si vous préférez une solution plus discrète et intégrée, découvrez nos plateaux tournants encastrés. Avec une installation au niveau du sol, ces systèmes offrent un accès simplifié et une esthétique élégante.', 'moovcar' ), mvc_allowed_html() ); ?>
		</p>
		<a href="<?php echo esc_url( get_permalink( 226 ) ); ?>"
			class="btn-primary"><?php esc_html_e( 'En savoir plus', 'moovcar' ); ?></a>
	</div>
</section>
<?php endif; ?>