<?php
/**
 * Bloc / Partners
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$type_logos = get_terms(
	array(
		'taxonomy'   => 'type-logos',
		'hide_empty' => false,
		'orderby'    => 'menu_order',
	)
);

if ( $type_logos ) : ?>
<section class="mvc-partners container pb-10 px-5 lg:px-0 grid grid-cols-12">
	<!-- <section class="mvc-partners container pb-10 px-5 lg:px-0 grid grid-cols-1 lg:grid-cols-2 gap-x-1 gap-y-4 text-center"> -->
	<div class="col-span-12 lg:col-start-2 lg:col-end-12 grid grid-cols-1 lg:grid-cols-2 gap-x-5 gap-y-6">
		<?php
		foreach ( $type_logos as $type_logo ) :
			$partners_query = new WP_Query(
				array(
					'post_type'      => 'partenaire',
					'posts_per_page' => -1,
					'orderby'        => 'menu_order',
					'tax_query'      => array(
						array(
							'taxonomy' => 'type-logos',
							'field'    => 'slug',
							'terms'    => $type_logo->slug,
						),
					),
				)
			);

			if ( $partners_query->have_posts() ) :
				?>
		<div>
			<h2 class="mb-2 text-xl font-display">
				<?php printf( esc_html( 'Nos %s', 'moovcar' ), mb_strtolower( $type_logo->name ) ); ?></h2>

			<ul class="flex flex-wrap items-center gap-x-5 gap-y-1">
				<?php
				while ( $partners_query->have_posts() ) :
					$partners_query->the_post();
					?>
				<li>
					<?php
					has_post_thumbnail() ? the_post_thumbnail( 'full', array( 'class' => 'mx-auto w-auto max-h-[100px]' ) ) : '';
					?>
				</li>
					<?php
				endwhile;
					wp_reset_postdata();
				?>
			</ul>
		</div>
				<?php
		endif;
	endforeach;
		?>
	</div>
</section>
<?php endif; ?>
