<?php
/**
 * Bloc / Services
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$excluded_page = array( 11, 226 );

if ( isset( $args['current_page_id'] ) ) :
	$excluded_page = array( $args['current_page_id'], 226 );
endif;

$pages_query = new WP_Query(
	array(
		'post_type'      => 'page',
		'posts_per_page' => 4,
		'post_parent'    => 206,
		'post__not_in'   => $excluded_page,
	)
);

if ( $pages_query->have_posts() ) : ?>
<ul class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-1">
	<?php
	while ( $pages_query->have_posts() ) :
		$pages_query->the_post();

		$usage = get_field( 'usage_theme' );
		?>
	<li <?php post_class( 'group/item h-[351px] rounded-lg relative overflow-hidden ' . mb_strtolower( $usage ) ); ?>>
		<picture class="block relative h-full">
			<div class="absolute inset-0 bg-gradient-to-b from-black/0 from-50% to-black/75"></div>
			<?php has_post_thumbnail() ? the_post_thumbnail( 'page-loop', array( 'class' => 'w-full h-full object-cover' ) ) : ''; ?>
		</picture>
		<div
			class="content absolute inset-0 p-2 flex flex-col items-start justify-start gap-y-2.5 text-white z-0 translate-y-17 transition-all duration-700 ease-out-cubic group-hover/item:!translate-y-0 group-hover/item:text-green-150">
			<div
				class="absolute inset-0 bg-green-25 pointer-events-none -z-10 translate-y-[60%] xl:translate-y-[50%] transition-transform duration-700 ease-out-cubic group-hover/item:!translate-y-0">
			</div>
			<h3>
				<div class="text-sm font-display uppercase"><?php esc_html_e( 'Plateaux tournants pour ', 'moovcar' ); ?></div>
				<div class="text-xl font-display"><?php echo isset( $usage ) ? esc_html( $usage ) : ''; ?></div>
			</h3>
			<p>
				<?php echo wp_kses( get_the_excerpt(), mvc_allowed_html() ); ?>
			</p>
			<a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-primary --simple">
				<div><?php esc_html_e( 'Découvrir', 'moovcar' ); ?></div>
			</a>
		</div>
	</li>
	<?php
	endwhile;
	wp_reset_postdata();
	?>
</ul>
<?php endif; ?>