<?php
/**
 * Template part for displaying connecteur categories menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */
$post_cats = get_terms(
	array(
		'taxonomy'   => 'category',
		'hide_empty' => false,
		'exclude'    => isset( $args['current_term_ids'] ) ? $args['current_term_ids'] : '',
	)
);

if ( $post_cats ) : ?>

<nav class="<?php echo ! is_single() ? 'mb-0' : ''; ?>"
	aria-label="<?php esc_html_e( 'Menu des catégories d\'articles de blog' ); ?>">
	<ul
		class="flex lg:flex-wrap pb-0.5 lg:pb-0 gap-0.75 lg:justify-center whitespace-nowrap overflow-x-scroll lg:overflow-x-hidden">
		<?php if ( ! is_single() ) : ?>
		<li>
			<a class="pill <?php echo is_home() ? '--active' : ''; ?>"
				href="<?php echo esc_url( get_permalink( get_option( 'page_for_posts' ) ) ); ?>"><?php esc_html_e( 'Tout', 'moovcar' ); ?></a>
		</li>
		<?php endif; ?>
		<?php foreach ( $post_cats as $key => $post_cat ) : ?>
		<li>
			<a class="pill <?php echo get_queried_object()->term_id === $post_cat->term_id ? '--active' : ''; ?>"
				href="<?php echo esc_url( get_term_link( $post_cat->term_id, $post_cat->taxonomy ) ); ?>"><?php echo $post_cat->name; ?></a>
		</li>
		<?php endforeach; ?>
	</ul>
</nav>

<?php
endif;