<?php
/**
 * Template part for displaying realisations
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$posts_query = new WP_Query(
	array(
		'post_type'      => 'post',
		'posts_per_page' => 9,
		'post__not_in'   => isset( $args['current_post_id'] ) ? array( $args['current_post_id'] ) : array(),
		'tax_query'      => isset( $args['category_id'] ) && $args['category_id'] ? array(
			array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => array( $args['category_id'] ),
			),
		) : array(),
	)
);

if ( $posts_query->have_posts() ) :
	?>
<section class="mvc-posts <?php echo ! is_single() ? 'py-7 lg:pb-10' : ''; ?> overflow-hidden">
	<div class="container px-1.5 lg:px-0">

		<div class="swiper default mb-2 posts-swiper overflow-visible" data-slides-per-view="3">
			<div class="mb-2 flex justify-between gap-x-2.5">
				<h2 class="text-2xl font-display">
					<?php
					if ( is_front_page() ) :
						esc_html_e( 'Blog', 'moovcar' );
					else :
						esc_html_e( 'Nos autres conseils', 'moovcar' );
					endif;
					?>
				</h2>
				<div class="swiper-controls ml-auto flex items-center justify-center">
					<div
						class="swiper-btn-prev w-2.5 h-2.5 flex items-center justify-center border border-transparent rounded-full cursor-pointer transition-[colors,opacity] duration-300 ease-out-expo hover:border-foreground focus:border-foreground [&.swiper-button-disabled]:opacity-50">
						<svg class="stroke-foreground -scale-x-100" width="13" height="12" viewBox="0 0 13 12" fill="none"
							xmlns="http://www.w3.org/2000/svg">
							<path d="M6.90987 1L12 6M12 6L6.90987 11M12 6L-3.92873e-07 6" stroke-linejoin="round" />
						</svg>
					</div>
					<div
						class="swiper-btn-next w-2.5 h-2.5 flex items-center justify-center border border-transparent rounded-full cursor-pointer transition-[colors,opacity] duration-300 ease-out-expo hover:border-foreground focus:border-foreground [&.swiper-button-disabled]:opacity-50">
						<svg class="stroke-foreground" width="13" height="12" viewBox="0 0 13 12" fill="none"
							xmlns="http://www.w3.org/2000/svg">
							<path d="M6.90987 1L12 6M12 6L6.90987 11M12 6L-3.92873e-07 6" stroke-linejoin="round" />
						</svg>
					</div>
				</div>
			</div>
			<div class="swiper-wrapper">
				<?php
				while ( $posts_query->have_posts() ) :
					$posts_query->the_post();
					?>
				<div class="swiper-slide h-auto">
					<?php
						get_template_part( 'template-parts/content/content', 'loop' );
					?>
				</div>
				<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>

		<div class="text-center">
			<a href="<?php echo esc_url( get_post_type_archive_link( 'realisation' ) ); ?>"
				class="btn-primary"><?php esc_html_e( 'Voir tous les articles', 'moovcar' ); ?></a>
		</div>
	</div>
</section>
<?php endif; ?>