<?php
/**
 * Realisation / Loop
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */
$post_cats = get_the_category( get_the_id() );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'h-full rounded-lg overflow-hidden' ); ?>>
	<a class="group/post flex flex-col h-full" href="<?php echo esc_url( get_permalink() ); ?>">
		<picture class="relative block h-[269px] bg-green-100">
			<?php if ( has_post_thumbnail() ) : ?>
				<?php the_post_thumbnail( 'realisation-loop', array( 'class' => 'w-full h-full object-cover' ) ); ?>
			<?php endif; ?>
		</picture>
		<div class="grow py-1.5 pl-2 pr-2.5 bg-gray-100 rounded-b-lg">
			<?php if ( isset( $post_cats ) ) : ?>
			<div class="mb-1 flex items-center gap-x-0.25">
				<?php foreach ( $post_cats as $post_cat ) : ?>
				<div
					class="px-0.75 py-[0.2rem] bg-foreground text-background rounded-btn text-xs font-display uppercase transition-colors duration-300 ease-out-expo group-hover/post:bg-green-75 group-hover/post:text-green-150">
					<?php echo esc_html( $post_cat->name ); ?></div>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
			<h3 class="mb-0.5 text-base font-medium"><?php the_title(); ?></h3>
			<div class="opacity-75"><?php echo wp_kses( get_the_excerpt(), mvc_allowed_html() ); ?></div>
		</div>
	</a>
</article>
