<?php
/**
 * Template part for displaying pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<section class="mvc-hero pt-7 lg:pt-9 pb-3.5 lg:pb-7">

		<div class="container px-1.5 lg:px-0 grid grid-cols-12 text-center">
			<div class="col-span-12 lg:col-start-3 2xl:col-start-4 lg:col-end-11 2xl:col-end-10">
				<h1 class="mb-5 lg:mb-7 text-2xl lg:text-3xl font-display">
					<?php echo wp_kses( get_the_title(), mvc_allowed_html() ); ?>
				</h1>
			</div>
		</div>

	</section>

	<?php mvc_post_thumbnail(); ?>

	<section class="mvc-content container px-1.5 lg:px-0 grid grid-cols-12">
		<div
			<?php mvc_content_class( 'entry-content col-span-12 lg:col-start-2 xl:col-start-3 lg:col-end-11 xl:col-end-12' ); ?>>
			<?php the_content(); ?>
		</div><!-- .entry-content -->
	</section>

</article><!-- #post-<?php the_ID(); ?> -->