<?php
/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$post_cats = get_the_category();

?>

<article id="post-<?php the_ID(); ?>"
	<?php post_class( 'container pt-3.5 pb-7 lg:pb-13 px-1.5 lg:px-0 grid grid-cols-12' ); ?>>

	<?php
	if ( function_exists( 'yoast_breadcrumb' ) ) {
		yoast_breadcrumb( '<div class="mb-5 col-span-12" id="breadcrumbs">', '</div>' );
	}
	?>

	<header class="entry-header mb-8 col-span-12 lg:col-start-2 lg:col-end-12 text-center">
		<?php if ( $post_cats ) : ?>
		<ul class="mb-2 flex flex-wrap justify-center gap-0.5"
			aria-label="<?php esc_html_e( 'Liste des catégories de l\'article', 'moovcar' ); ?>">
			<?php foreach ( $post_cats as $post_cat ) : ?>
			<li
				class="flex px-0.75 pt-[0.4rem] pb-0.25  bg-green-150 text-white rounded-btn font-display font-medium uppercase">
				<?php echo esc_html( $post_cat->name ); ?></li>
			<?php endforeach; ?>
		</ul>
		<?php endif; ?>
		<h1 class="mx-auto mb-3 max-w-full w-[60rem] text-2xl font-display"><?php the_title(); ?></h1>
		<?php mvc_post_thumbnail( 'post-large' ); ?>
	</header><!-- .entry-header -->


	<div
		<?php mvc_content_class( 'entry-content col-span-12 lg:col-start-2 lg:col-end-12 xl:col-start-3 xl:col-end-11 2xl:col-start-4 2xl:col-end-10' ); ?>>
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers. */
					__( 'Continue reading<span class="sr-only"> "%s"</span>', 'moovcar' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			)
		);

		wp_link_pages(
			array(
				'before' => '<div>' . __( 'Pages:', 'moovcar' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

</article><!-- #post-${ID} -->