<?php
/**
 * Template part for displaying the footer content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

?>

<footer class="pt-6 lg:pt-9 rounded-t-btn bg-green-150 text-white" id="colophon">

	<div class="container px-1.5 lg:px-0 grid grid-cols-12 gap-x-1 gap-y-3">

		<div class="col-span-12">
			<figure>
				<img class="w-[240px] lg:w-auto" width="312" height="48"
					src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-logo-white.svg" alt="">
			</figure>
		</div>

		<div class="col-span-12 lg:col-span-6">
			<ul class="mb-4 flex flex-col gap-y-0.75" aria-label="<?php esc_html_e( 'Menu de contact', 'moovcar' ); ?>">
				<li class="flex items-center gap-x-1">
					<figure class="w-[22px] h-[22px] flex items-center justify-center">
						<svg class="fill-green-50 w-full" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20.17 20.17"
							aria-hidden="true">
							<path
								d="M10.91.84c0-.22.09-.44.25-.6.16-.16.37-.25.6-.25,2.23,0,4.37.89,5.95,2.47,1.58,1.58,2.47,3.72,2.47,5.95,0,.22-.09.44-.25.6-.16.16-.37.25-.6.25s-.44-.09-.6-.25c-.16-.16-.25-.37-.25-.6,0-1.79-.71-3.5-1.97-4.76-1.26-1.26-2.97-1.97-4.76-1.97-.22,0-.44-.09-.6-.25-.16-.16-.25-.37-.25-.6ZM11.75,5.05c.89,0,1.75.35,2.38.99.63.63.99,1.49.99,2.38,0,.22.09.44.25.6.16.16.37.25.6.25s.44-.09.6-.25c.16-.16.25-.37.25-.6,0-1.34-.53-2.62-1.48-3.57-.95-.95-2.23-1.48-3.57-1.48-.22,0-.44.09-.6.25-.16.16-.25.37-.25.6s.09.44.25.6c.16.16.37.25.6.25ZM19.4,14.09c.49.49.76,1.15.76,1.84s-.27,1.35-.76,1.84l-.77.88C11.74,25.26-5.03,8.49,1.47,1.57l.97-.84C2.93.26,3.58,0,4.26,0c.68,0,1.33.28,1.81.76.03.03,1.59,2.05,1.59,2.05.46.49.72,1.13.72,1.8,0,.67-.26,1.32-.73,1.8l-.97,1.23c.54,1.31,1.33,2.5,2.33,3.5,1,1,2.19,1.8,3.5,2.34l1.23-.98c.48-.46,1.13-.72,1.8-.72.67,0,1.32.26,1.8.72,0,0,2.02,1.56,2.05,1.58ZM18.25,15.31s-2.01-1.55-2.04-1.58c-.17-.17-.41-.27-.65-.27s-.48.1-.65.27c-.02.02-1.72,1.38-1.72,1.38-.11.09-.25.15-.4.17-.14.02-.29,0-.43-.05-1.7-.63-3.24-1.62-4.52-2.9-1.28-1.28-2.27-2.82-2.91-4.51-.06-.14-.07-.29-.05-.44.02-.15.08-.29.18-.4,0,0,1.35-1.7,1.38-1.72.17-.17.27-.41.27-.65s-.1-.48-.27-.65c-.03-.03-1.58-2.04-1.58-2.04-.18-.16-.41-.24-.64-.24-.24,0-.46.1-.63.27l-.97.84c-4.75,5.71,9.79,19.44,14.79,14.71l.77-.88c.18-.17.29-.4.3-.64.01-.24-.07-.48-.23-.67Z" />
						</svg>
					</figure>
					<a class="relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100"
						href="tel:+33366880979">+33 3 66 88 09 79</a>
				</li>
				<li class="flex items-center gap-x-1">
					<figure class="w-[22px] h-[22px] flex items-center justify-center">
						<svg class="fill-green-50" width="20" height="17" xmlns="http://www.w3.org/2000/svg"
							viewBox="0 0 20.33 17.58">
							<path
								d="M14.75,17.58H5.58c-3.55,0-5.58-2.04-5.58-5.58v-6.42C0,2.04,2.04,0,5.58,0h9.17c3.55,0,5.58,2.04,5.58,5.58v6.42c0,3.55-2.04,5.58-5.58,5.58ZM5.58,2c-2.44,0-3.58,1.14-3.58,3.58v6.42c0,2.45,1.14,3.58,3.58,3.58h9.17c2.44,0,3.58-1.14,3.58-3.58v-6.42c0-2.44-1.14-3.58-3.58-3.58H5.58Z" />
							<path
								d="M10.16,9.9c-.84,0-1.68-.26-2.34-.78l-2.86-2.29c-.43-.35-.5-.97-.15-1.41.35-.43.98-.5,1.41-.15l2.86,2.29c.58.46,1.61.46,2.19,0l2.87-2.29c.43-.35,1.06-.27,1.41.16.34.43.27,1.06-.16,1.41l-2.87,2.29c-.66.52-1.5.79-2.34.79Z" />
						</svg>
					</figure>
					<a class="relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100"
						href="mailto:contact@moovcar360.com">contact@moovcar360.com</a>
				</li>
				<li class="flex items-center gap-x-1">
					<figure class="w-[22px] h-[22px] flex items-center justify-center">
						<svg class="fill-green-50" width="17.81" height="20.33" xmlns="http://www.w3.org/2000/svg"
							viewBox="0 0 17.81 20.33">
							<path
								d="M8.91,12.48c-2.13,0-3.86-1.73-3.86-3.86s1.73-3.86,3.86-3.86,3.86,1.73,3.86,3.86-1.73,3.86-3.86,3.86ZM8.91,6.76c-1.03,0-1.86.83-1.86,1.86s.83,1.86,1.86,1.86,1.86-.83,1.86-1.86-.83-1.86-1.86-1.86Z" />
							<path
								d="M8.91,20.33c-1.44,0-2.88-.54-4-1.62C2.14,16.06-.9,11.82.25,6.73H.25C1.31,2.08,5.36,0,8.9,0h0c3.55,0,7.6,2.09,8.65,6.74,1.15,5.09-1.9,9.32-4.66,11.98-1.12,1.08-2.55,1.62-3.99,1.62ZM2.2,7.17c-.95,4.18,1.7,7.8,4.09,10.1,1.47,1.41,3.76,1.41,5.22,0,2.39-2.3,5.05-5.92,4.1-10.1-.86-3.82-4.15-5.18-6.7-5.18h0c-2.55,0-5.84,1.35-6.7,5.17Z" />
						</svg>
					</figure>
					<a class="relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100"
						href="https://maps.app.goo.gl/g2EouQYA7q8x836P7" target="_blank">7 rue Chappe, 59650 Villeneuve-d'Ascq</a>
				</li>
			</ul>
			<ul class="flex items-center gap-x-1">
				<li>
					<a class="group/social w-[46px] h-[46px] flex items-center justify-center bg-green-75 rounded-full transition-colors duration-300 ease-out-expo hover:bg-green-100 focus:bg-green-100"
						href="https://www.facebook.com/yilplat.fr/?locale=fr_FR" target="_blank">
						<svg class="fill-green-150 transition-colors duration-300 ease-out-expo group-hover/social:fill-white"
							xmlns="http://www.w3.org/2000/svg" width="10" height="18" viewBox="0 0 10 18" fill="none"
							aria-hidden="true">
							<path
								d="M6.31163 17.4937V9.74535H8.91155L9.2996 6.72521H6.31163V4.79977C6.31163 3.92245 6.55222 3.3324 7.80949 3.3324H9.40825V0.622806C9.12886 0.583986 8.18202 0.506348 7.07996 0.506348C4.77496 0.506348 3.19948 1.91161 3.19948 4.49698V6.72521H0.591797V9.74535H3.19948V17.4937H6.31163Z" />
						</svg>
						<span class="sr-only"><?php esc_html_e( 'Suivez-nous sur Facebook', 'moovcar' ); ?></span>
					</a>
				</li>
				<li>
					<a class="group/social w-[46px] h-[46px] flex items-center justify-center bg-green-75 rounded-full transition-colors duration-300 ease-out-expo hover:bg-green-100 focus:bg-green-100"
						href="https://www.instagram.com/plateau_tournant_automobile/" target="_blank">
						<svg class="fill-green-150 transition-colors duration-300 ease-out-expo group-hover/social:fill-white"
							xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
							<path
								d="M10,1.8c2.67,0,2.99.01,4.04.06.97.04,1.5.21,1.86.34.43.16.83.42,1.15.75.33.32.59.72.75,1.15.14.35.3.88.34,1.86.05,1.05.06,1.37.06,4.04s-.01,2.99-.06,4.04c-.04.97-.21,1.5-.34,1.86-.17.43-.42.82-.75,1.15s-.72.58-1.15.75c-.35.14-.88.3-1.86.34-1.05.05-1.37.06-4.04.06s-2.99-.01-4.04-.06c-.97-.04-1.5-.21-1.86-.34-.43-.16-.83-.42-1.15-.75-.33-.32-.59-.72-.75-1.15-.14-.35-.3-.88-.34-1.86-.05-1.05-.06-1.37-.06-4.04s.01-2.99.06-4.04c.04-.97.21-1.5.34-1.86.16-.43.42-.83.75-1.15.32-.33.72-.59,1.15-.75.35-.14.88-.3,1.86-.34,1.05-.05,1.37-.06,4.04-.06M10,0c-2.72,0-3.06.01-4.12.06-1.06.05-1.79.22-2.43.46-.67.25-1.27.64-1.77,1.15-.51.5-.9,1.1-1.15,1.77-.25.64-.42,1.36-.46,2.43-.05,1.07-.06,1.41-.06,4.12s.01,3.06.06,4.12c.05,1.06.22,1.79.46,2.43.25.67.64,1.27,1.15,1.77.5.51,1.1.9,1.77,1.15.64.25,1.36.42,2.43.46,1.07.05,1.41.06,4.12.06s3.06-.01,4.12-.06c1.06-.05,1.79-.22,2.43-.46.66-.26,1.27-.65,1.77-1.15.5-.5.9-1.11,1.15-1.77.25-.64.42-1.36.46-2.43.05-1.07.06-1.41.06-4.12s-.01-3.06-.06-4.12c-.05-1.06-.22-1.79-.46-2.43-.25-.67-.64-1.27-1.15-1.77-.5-.51-1.1-.9-1.77-1.15-.64-.25-1.36-.42-2.43-.46-1.07-.05-1.41-.06-4.12-.06h0Z" />
							<path
								d="M10,4.87c-1.02,0-2.01.3-2.85.87s-1.5,1.37-1.89,2.3c-.39.94-.49,1.97-.29,2.97.2,1,.69,1.91,1.41,2.63.72.72,1.63,1.21,2.63,1.41,1,.2,2.03.1,2.97-.29.94-.39,1.74-1.05,2.3-1.89.56-.84.87-1.84.87-2.85,0-1.36-.54-2.67-1.5-3.63-.96-.96-2.27-1.5-3.63-1.5ZM10,13.33c-.66,0-1.3-.2-1.85-.56-.55-.37-.98-.89-1.23-1.5-.25-.61-.32-1.28-.19-1.93.13-.65.45-1.24.91-1.71.47-.47,1.06-.78,1.71-.91.65-.13,1.32-.06,1.93.19.61.25,1.13.68,1.5,1.23.37.55.56,1.19.56,1.85,0,.88-.35,1.73-.98,2.36-.63.63-1.47.98-2.36.98Z" />
							<path d="M15.34,5.86c.66,0,1.2-.54,1.2-1.2s-.54-1.2-1.2-1.2-1.2.54-1.2,1.2.54,1.2,1.2,1.2Z" />
						</svg>
						<span class="sr-only"><?php esc_html_e( 'Suivez-nous sur Instagram', 'moovcar' ); ?></span>
					</a>
				</li>
				<li>
					<a class="group/social w-[46px] h-[46px] flex items-center justify-center bg-green-75 rounded-full transition-colors duration-300 ease-out-expo hover:bg-green-100 focus:bg-green-100"
						href="https://www.linkedin.com/company/moovcar360/" target="_blank">
						<svg class="fill-green-150 transition-colors duration-300 ease-out-expo group-hover/social:fill-white"
							xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" fill="none"
							aria-hidden="true">
							<path fill-rule="evenodd" clip-rule="evenodd"
								d="M14.4444 14.4444H11.4766V9.38948C11.4766 8.00354 10.9499 7.22904 9.85297 7.22904C8.65961 7.22904 8.03613 8.03503 8.03613 9.38948V14.4444H5.17593V4.81482H8.03613V6.11193C8.03613 6.11193 8.89612 4.52062 10.9396 4.52062C12.9821 4.52062 14.4444 5.76791 14.4444 8.34756V14.4444ZM1.76371 3.55389C0.78946 3.55389 0 2.75824 0 1.77695C0 0.795655 0.78946 0 1.76371 0C2.73796 0 3.52695 0.795655 3.52695 1.77695C3.52695 2.75824 2.73796 3.55389 1.76371 3.55389ZM0.28682 14.4444H3.26928V4.81482H0.28682V14.4444Z">
							</path>
						</svg>
						<span class="sr-only"><?php esc_html_e( 'Suivez-nous sur Instagram', 'moovcar' ); ?></span>
					</a>
				</li>
				<li>
					<a class="group/social w-[46px] h-[46px] flex items-center justify-center bg-green-75 rounded-full transition-colors duration-300 ease-out-expo hover:bg-green-100 focus:bg-green-100"
						href="https://www.youtube.com/@moovcar3608" target="_blank">
						<svg class="fill-green-150 transition-colors duration-300 ease-out-expo group-hover/social:fill-white"
							xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14" fill="none"
							aria-hidden="true">
							<path fill-rule="evenodd" clip-rule="evenodd"
								d="M17.8136 0.448C18.6746 0.677435 19.3513 1.35099 19.5818 2.2081C19.9983 3.76006 20 7.00002 20 7.00002C20 7.00002 20 10.24 19.5818 11.792C19.3513 12.6491 18.6746 13.3226 17.8136 13.552C16.2545 13.9683 9.99996 13.9683 9.99996 13.9683C9.99996 13.9683 3.74547 13.9683 2.18636 13.552C1.32532 13.3226 0.648666 12.6491 0.418176 11.792C0 10.24 0 7.00002 0 7.00002C0 7.00002 0 3.76006 0.418176 2.2081C0.648666 1.35099 1.32532 0.677435 2.18636 0.448C3.74547 0.0317383 9.99996 0.0317383 9.99996 0.0317383C9.99996 0.0317383 16.2545 0.0317383 17.8136 0.448ZM13.1942 7.00012L7.99826 9.98603V4.01416L13.1942 7.00012Z" />
						</svg>
						<span class="sr-only"><?php esc_html_e( 'Suivez-nous sur Instagram', 'moovcar' ); ?></span>
					</a>
				</li>
				<li class="lg:ml-1.5">
					<button type="button" data-micromodal-trigger="modal-contact"
						class="btn-primary --simple --green"><?php esc_html_e( 'Nous contacter', 'moovcar' ); ?></button>
				</li>
			</ul>
		</div>

		<?php if ( has_nav_menu( 'footer-realisations' ) ) : ?>
		<div class="col-span-12 lg:col-start-8 lg:col-end-11">
			<div class="mb-1.5 font-medium"><?php esc_html_e( 'Utilisations', 'moovcar' ); ?></div>
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'footer-realisations',
					'menu_id'        => 'footer-menu-realisations',
					'container'      => false,
					'menu_class'     => 'flex flex-col gap-1',
					'a_class'        => 'relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100',
				)
			);
			?>
		</div>
		<?php endif; ?>

		<?php if ( has_nav_menu( 'footer-resources' ) ) : ?>
		<div class="col-span-12 lg:col-start-11 lg:col-end-13">
			<div class="mb-1.5 font-medium"><?php esc_html_e( 'Ressources', 'moovcar' ); ?></div>
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'footer-resources',
					'menu_id'        => 'footer-menu-resources',
					'container'      => false,
					'menu_class'     => 'flex flex-col gap-1',
					'a_class'        => 'relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100',
				)
			);
			?>
		</div>
		<?php endif; ?>

		<div class="col-span-12 pt-3 lg:pt-6 text-center lg:text-right">
			<a href="#" class="back-to-top btn-secondary --white"><?php esc_html_e( 'Haut de page', 'moovcar' ); ?></a>
		</div>

		<div class="col-span-12 pb-1 flex flex-col lg:flex-row items-center gap-x-3 gap-y-1">
			<span>&copy; <?php echo esc_html( date( 'Y' ) ); ?>
				<?php esc_html_e( 'Moovcar 360. Tous droits réservés.', 'moovcar' ); ?></span>

			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'footer-legal',
					'menu_id'        => 'footer-menu-legal',
					'container'      => false,
					'menu_class'     => 'lg:ml-auto flex gap-3',
					'a_class'        => 'relative inline-block after:absolute after:top-full after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-300 after:ease-out-expo hover:after:origin-left hover:after:scale-x-100 focus:after:origin-left focus:after:scale-x-100',
				)
			);
			?>

			<a href="https://konfiture.com/realisations" target="_blank"
				class="group/madeby flex items-center gap-0.5 no-underline">
				<div
					class="relative no-underline after:absolute after:bottom-0 after:left-0 after:w-full after:h-px after:bg-white after:origin-right after:scale-x-0 after:transition-transform after:duration-500 after:ease-out-expo group-hover/madeby:after:scale-x-100 group-hover/madeby:after:origin-left">
					<?php esc_html_e( 'Site réalisé par l\'agence WordPress Konfiture', 'moovcar' ); ?></div>
				<div class="hidden md:block">
					<svg class="fill-background" width="20" height="20" viewBox="0 0 1809.38 1809.4">
						<g id="mark">
							<path
								d="M904.71,0C405.04,0,0,405.04,0,904.69s405.04,904.71,904.71,904.71,904.67-405.05,904.67-904.71S1404.34,0,904.71,0ZM543.93,1061.64c-87.14,0-157.78-70.64-157.78-157.79s70.64-157.77,157.78-157.77,157.78,70.63,157.78,157.77-70.65,157.79-157.78,157.79ZM1387.84,1274h-139.42s-17.33,3.59-19.5.34l-255.05-340.15v322.82c4.83,14.08-7.09,26-21.18,26.79h-126.75c-15.15-.79-28.58-26.79-28.58-26.79v-702.68c0-13.85,10.7-25.59,25.66-25.59h124.84c14.3,0,26.01,11.7,26.01,26.01v279.98l237.46-295.33c4.27-5.32,13.92-10.66,20.33-10.66h134.77c20.33,0,31.04,23.46,19.25,39.45l-250.31,312.39,272.77,353.96c11.76,16,0,39.46-20.31,39.46h.01Z" />
						</g>
					</svg>
				</div>
			</a>
		</div>
	</div>

</footer><!-- #colophon -->

<?php get_template_part( 'template-parts/modals/modal', 'contact' ); ?>

<?php get_template_part( 'template-parts/modals/modal', 'devis' ); ?>