<?php
/**
 * Template part for displaying the header content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

?>

<div id="mobile-menu"
	class="fixed inset-0 z-50 bg-gray-100 translate-x-full [&.is-open]:translate-x-0 transition-transform duration-700 ease-out-expo overflow-y-auto"
	aria-hidden="true">
	<div tabindex="-1" data-micromodal-close>
		<div role="dialog" aria-modal="true" aria-labelledby="mobile-menu-title">

			<header class="flex items-center justify-between py-1 px-1.5">
				<div id="mobile-menu-title" class="sr-only">
					<?php esc_html_e( 'Menu mobile', 'moovcar' ); ?>
				</div>
				<button
					class="relative ml-auto w-[2.25rem] h-[2.25rem] flex items-center justify-center z-10 before:absolute before:top-1/2 before:left-1/2 before:w-full before:h-full before:-translate-x-1/2 before:-translate-y-1/2 before:rounded-full before:border before:border-transparent before:transition-colors before:duration-300 before:ease-out-expo before:pointer-events-none  hover:before:border-primary"
					type="button" data-micromodal-close="mobile"
					aria-label="<?php esc_html_e( 'Fermer le menu mobile', 'moovcar' ); ?>">
					<svg class="pointer-events-none" xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11"
						fill="none">
						<path d="M0.5 0.5L10.5 10.5" stroke="#202D3A" stroke-width="1.25" />
						<path d="M10.5 0.5L0.5 10.5" stroke="#202D3A" stroke-width="1.25" />
					</svg>
				</button>
			</header>

			<div id="mobile-menu-content">
				<nav class="px-1.5" id="site-mobile-nav" aria-label="<?php esc_attr_e( 'Navigation mobile', 'moovcar' ); ?>">
					<ul id="mobile-menu-list" class="flex flex-col items-stretch gap-y-0.5">
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'container'      => '',
								'items_wrap'     => '%3$s',
								'li_class'       => 'm-0',
								'a_class'        => 'relative flex items-center justify-between gap-0.5 py-1 pl-1.5 pr-0.75 min-h-[60px] rounded-lg bg-green-150/5 transition-colors duration-300 ease-out-expo focus:outline focus:outline-2 focus:outline-green-150',
								'walker'         => new A11y_Walker_Nav_Menu(),
							)
						);
						?>
						<li>
							<?php do_action( 'wpml_add_language_selector' ); ?>
						</li>
						<li>
							<button type="button" href="#" data-micromodal-trigger="contact"
								class="btn-primary --simple w-full justify-center">
								<?php esc_html_e( 'Nous contacter', 'moovcar' ); ?>
							</button>
						</li>
					</ul>
				</nav>
			</div>

		</div>
	</div>
</div>

<header id="masthead"
	class="<?php echo is_front_page() ? 'fixed' : 'sticky bg-background'; ?> top-0 inset-x-0 py-1.5 lg:py-0 px-1.5 lg:px-2.5 flex items-center justify-between z-40 transition-colors duration-300 ease-out-expo [&.filled]:bg-background [&.focused]:bg-green-25">

	<a href="<?php echo esc_url( get_home_url() ); ?>">
		<span class="sr-only"><?php esc_html_e( 'Revenir à l\'accueil', 'moovcar' ); ?></span>
		<img width="142" height="20" src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/moovcar360-logo.svg"
			alt="">
	</a>

	<button class="lg:hidden" data-micromodal-trigger="mobile-menu">
		<span class="sr-only"><?php esc_html_e( 'Ouvrir le menu', 'moovcar' ); ?></span>
		<div class="w-2 h-1 flex flex-col items-center justify-between">
			<div class="w-full h-[2px] bg-primary"></div>
			<div class="w-full h-[2px] bg-primary"></div>
			<div class="w-full h-[2px] bg-primary"></div>
		</div>
	</button>

	<nav class="hidden lg:block" id="site-navigation" aria-label="<?php esc_attr_e( 'Main Navigation', 'moovcar' ); ?>">
		<ul class="flex gap-x-0.5 items-center" id="primary-menu">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'primary',
					'menu_id'        => 'primary-menu',
					'container'      => false,
					'menu_class'     => 'flex gap-x-0.5',
					'a_class'        => 'relative flex items-center gap-x-1 py-1.75 px-1.5 focus:bg-background transition-colors duration-300 ease-in-out',
					'items_wrap'     => '%3$s',
					'walker'         => new Aria_Walker_Nav_Menu(),
				)
			);
			?>
			<li class="pl-1.5 hidden lg:block">
				<?php do_action( 'wpml_add_language_selector' ); ?>
			</li>
			<li>
				<button type="button" href="#" data-micromodal-trigger="contact" class="btn-primary --simple">
					<?php esc_html_e( 'Nous contacter', 'moovcar' ); ?>
				</button>
			</li>
		</ul>
	</nav><!-- #site-navigation -->

</header><!-- #masthead -->
