<?php
/**
 * Template part for displaying the contact modal
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

?>
<div id="contact"
	class="group/modal fixed inset-0 z-50 bg-green-150/75 opacity-0 pointer-events-none transition-opacity duration-700 ease-out-expo overflow-y-auto [&.is-open]:pointer-events-auto [&.is-open]:opacity-100"
	aria-hidden="true">
	<div class="h-full flex justify-center items-center " tabindex="-1" data-micromodal-close>
		<div
			class="relative w-[76.5rem] max-h-[80vh] bg-green-150 translate-y-4 transition-transform duration-700 ease-out-expo group-[.is-open]/modal:translate-y-0"
			role="dialog" aria-modal="true" aria-labelledby="contact-title">

			<button class="absolute top-1.5 right-1.5 ml-auto w-1.5 h-1.5 flex items-center justify-center z-10" type="button"
				data-micromodal-close="mobile" aria-label="<?php esc_html_e( 'Fermer le menu mobile', 'moovcar' ); ?>">
				<svg class="pointer-events-none" xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
					fill="none" aria-hidden="true">
					<path d="M1 1L21 21" stroke="#F2F2F2" stroke-width="1.5" stroke-linejoin="bevel" />
					<path d="M21 1L1 21" stroke="#F2F2F2" stroke-width="1.5" stroke-linejoin="bevel" />
				</svg>
			</button>

			<header class="pt-4 lg:pt-6 px-2 lg:px-8 text-center">
				<div class="mb-4 text-2xl font-display text-white" id="contact-title">
					<?php esc_html_e( 'Contactez-nous', 'moovcar' ); ?>
				</div>
			</header>

			<div class="pb-4 lg:pb-6 px-2 lg:px-8" id="contact-content">
				<?php echo do_shortcode( '[contact-form-7 id="bc7e9ac" title="Formulaire de contact" html_class="mvc-contact__form modal-form"]' ); ?>
			</div>

		</div>
	</div>
</div>
