<?php
/**
 * Template part for displaying the devis modal
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$usage_calendar_link = get_field( 'usage_calendar_link', 206 ) ? get_field( 'usage_calendar_link', 206 ) : 'https://calendly.com/moovcar360/30min';

?>
<div id="devis"
	class="group/modal fixed inset-0 z-50 bg-green-150/75 opacity-0 pointer-events-none transition-opacity duration-700 ease-out-expo overflow-y-auto [&.is-open]:pointer-events-auto [&.is-open]:opacity-100"
	aria-hidden="true">
	<div class="h-full flex justify-center items-center " tabindex="-1" data-micromodal-close>
		<div
			class="relative w-[76.5rem] max-h-screen bg-green-150 translate-y-4 transition-transform duration-700 ease-out-expo group-[.is-open]/modal:translate-y-0 overflow-y-scroll"
			role="dialog" aria-modal="true" aria-labelledby="devis-title">

			<button class="absolute top-1.5 right-1.5 ml-auto w-1.5 h-1.5 flex items-center justify-center z-10" type="button"
				data-micromodal-close="mobile" aria-label="<?php esc_html_e( 'Fermer le menu mobile', 'moovcar' ); ?>">
				<svg class="pointer-events-none" xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
					fill="none" aria-hidden="true">
					<path d="M1 1L21 21" stroke="#F2F2F2" stroke-width="1.5" stroke-linejoin="bevel" />
					<path d="M21 1L1 21" stroke="#F2F2F2" stroke-width="1.5" stroke-linejoin="bevel" />
				</svg>
			</button>

			<header class="pt-4 lg:pt-6 px-2 lg:px-8 text-center">
				<div class="mb-4 text-2xl font-display text-white" id="devis-title">
					<?php esc_html_e( 'Demandez un devis', 'moovcar' ); ?>
				</div>
			</header>

			<div class="pb-4 lg:pb-6 px-2 lg:px-8" id="contact-content">
				<iframe class="w-full h-[60rem]" loading="lazy" src="<?php echo esc_url( $usage_calendar_link ); ?>"></iframe>
			</div>

		</div>
	</div>
</div>