<?php
/**
 * Realisation / Loop
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */
$realisation_terms = get_the_terms( get_the_ID(), 'realisation-category' );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'relative rounded-lg overflow-hidden' ); ?>>
	<a class="group/real block" href="<?php echo esc_url( get_permalink() ); ?>">
		<picture class="relative block h-[445px] bg-green-100">
			<?php if ( has_post_thumbnail() ) : ?>
				<?php the_post_thumbnail( 'realisation-loop', array( 'class' => 'w-full h-full object-cover' ) ); ?>
			<?php endif; ?>
		</picture>
		<div class="absolute inset-x-0 bottom-0 p-1.5 bg-black/20 backdrop-blur-lg text-white rounded-b-lg">
			<?php if ( isset( $realisation_terms ) ) : ?>
			<div class="mb-0.5 flex items-center gap-x-0.25">
				<?php foreach ( $realisation_terms as $realisation_term ) : ?>
				<div
					class="px-0.75 pt-[0.2rem] pb-[0.2rem] bg-foreground text-background rounded-btn text-xs font-display uppercase transition-colors duration-300 ease-out-expo group-hover/real:bg-green-75 group-hover/real:text-green-150">
					<?php echo esc_html( $realisation_term->name ); ?></div>
				<?php endforeach; ?>
			</div>
			<h3 class="text-lg font-display"><?php the_title(); ?></h3>
			<?php endif; ?>
		</div>
	</a>
</article>
