<?php
/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$realisation_terms = get_the_terms( get_the_id(), 'realisation-category' );

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-realisation pb-7 lg:pb-13' ); ?>>

	<header class="entry-header mvc-hero relative mb-8 h-auto md:h-[490px] lg:h-[690px] text-white overflow-hidden">

		<div
			class="absolute inset-y-0 left-0 w-full lg:w-[57%] bg-gradient-to-r from-green-150/75 to-transparent to-[98%] backdrop-blur-[8px] -z-10">
		</div>

		<?php if ( has_post_thumbnail() ) : ?>
		<figure class="absolute inset-0 -z-20">
			<?php the_post_thumbnail( 'post-large', array( 'class' => 'w-full h-full object-cover' ) ); ?>
		</figure>
		<?php endif; ?>

		<div class="container px-1.5 lg:px-0 pt-3 pb-4.5 h-full flex flex-col items-start justify-between gap-y-6">
			<a href="<?php echo $realisation_terms && isset( $realisation_terms ) ? esc_url( get_term_link( $realisation_terms[0]->term_id ) ) : esc_url( get_post_type_archive_link( 'realisation' ) ); ?>"
				class="btn-secondary --back --white"><?php esc_html_e( 'Retour aux réalisations', 'moovcar' ); ?></a>

			<div class="grid grid-cols-12">
				<div class="col-span-12 lg:col-span-6">

					<?php if ( $realisation_terms ) : ?>
					<ul class="mb-2 flex gap-0.5"
						aria-label="<?php esc_html_e( 'Liste des catégories de la réalisation', 'moovcar' ); ?>">
						<?php foreach ( $realisation_terms as $realisation_term ) : ?>
						<li
							class="flex px-0.75 pt-[0.4rem] pb-0.25 bg-background text-foreground rounded-btn font-display font-medium uppercase">
							<?php echo esc_html( $realisation_term->name ); ?></li>
						<?php endforeach; ?>
					</ul>
					<?php endif; ?>

					<h1 class="max-w-full w-[530px] text-2xl font-display"><?php the_title(); ?></h1>

				</div>
			</div>
		</div>
	</header><!-- .entry-header -->

	<section class="container px-1.5 lg:px-0 grid grid-cols-12">
		<div <?php mvc_content_class( 'entry-content col-span-12 lg:col-start-2 lg:col-end-12' ); ?>>
			<?php the_content(); ?>
		</div><!-- .entry-content -->
	</section>

</article><!-- #post-${ID} -->