<?php
/**
 * Reviews / Loop
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package moovcar
 */

$avis_rank = get_field( 'avis_rank' );
$avis_rank = $avis_rank * 20;
?>
<article id="post-<?php the_ID(); ?>"
	<?php post_class( 'py-2.5 pl-2 pr-3 h-full flex flex-col-reverse justify-between border border-blue-50 rounded-lg overflow-hidden' ); ?>>
	<h3 class="text-base font-medium"><?php echo esc_html( get_the_title() ); ?></h3>
	<blockquote class="mt-auto mb-2"><?php echo wp_kses( get_the_content(), mvc_allowed_html() ); ?></blockquote>
	<div class="review-rank relative mb-2 h-[17px] w-[111px] bg-no-repeat">
		<div class="absolute top-0 left-0 h-full bg-no-repeat"
			style="width: <?php echo esc_html( sprintf( '%s%%', $avis_rank ) ); ?>">
		</div>
	</div>
</article>
